/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl.interval;

import at.ssw.visualizer.model.interval.ChildInterval;
import at.ssw.visualizer.model.interval.Interval;
import at.ssw.visualizer.model.interval.Range;
import at.ssw.visualizer.model.interval.UsePosition;
import at.ssw.visualizer.modelimpl.interval.IntervalImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ChildIntervalImpl
implements ChildInterval,
Comparable<ChildIntervalImpl> {
    private Interval parent;
    private String regNum;
    private String type;
    private String operand;
    private String spillState;
    private ChildInterval registerHint;
    private Range[] ranges;
    private UsePosition[] usePositions;

    public void setValues(String regNum, String type, String operand, String spillState, ChildInterval registerHint, Range[] ranges, UsePosition[] usePositions) {
        this.regNum = regNum;
        this.type = type;
        this.operand = operand;
        this.spillState = spillState;
        this.registerHint = registerHint;
        this.ranges = ranges;
        this.usePositions = usePositions;
    }

    @Override
    public Interval getParent() {
        return this.parent;
    }

    protected void setParent(IntervalImpl parent) {
        this.parent = parent;
    }

    @Override
    public String getRegNum() {
        return this.regNum;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getOperand() {
        return this.operand;
    }

    @Override
    public String getSpillState() {
        return this.spillState;
    }

    @Override
    public ChildInterval getRegisterHint() {
        return this.registerHint;
    }

    @Override
    public List<Range> getRanges() {
        return Collections.unmodifiableList(Arrays.asList(this.ranges));
    }

    @Override
    public List<UsePosition> getUsePositions() {
        return Collections.unmodifiableList(Arrays.asList(this.usePositions));
    }

    @Override
    public int getFrom() {
        return this.ranges[0].getFrom();
    }

    @Override
    public int getTo() {
        return this.ranges[this.ranges.length - 1].getTo();
    }

    @Override
    public int compareTo(ChildIntervalImpl other) {
        return this.getFrom() - other.getFrom();
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append(this.regNum);
        result.append(": ");
        result.append(this.getType());
        result.append(", ");
        result.append(this.getOperand());
        result.append(", ");
        if (this.registerHint != null) {
            result.append(this.registerHint.getRegNum());
        } else {
            result.append("null");
        }
        result.append("  ");
        for (i = 0; i < this.ranges.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.ranges[i]);
        }
        result.append("  ");
        for (i = 0; i < this.usePositions.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.usePositions[i]);
        }
        return result.toString();
    }
}

