/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl.interval;

import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.interval.Interval;
import at.ssw.visualizer.model.interval.IntervalList;
import at.ssw.visualizer.modelimpl.CompilationElementImpl;
import at.ssw.visualizer.modelimpl.interval.IntervalImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class IntervalListImpl
extends CompilationElementImpl
implements IntervalList {
    private Interval[] intervals;
    private ControlFlowGraph controlFlowGraph;
    private int numLIROperations;

    public IntervalListImpl(String shortName, String name, IntervalImpl[] intervals, ControlFlowGraph controlFlowGraph) {
        super(shortName, name);
        this.intervals = intervals;
        this.controlFlowGraph = controlFlowGraph;
        for (IntervalImpl interval : intervals) {
            interval.setParent(this);
            this.numLIROperations = Math.max(this.numLIROperations, interval.getTo());
        }
        for (BasicBlock basicBlock : controlFlowGraph.getBasicBlocks()) {
            this.numLIROperations = Math.max(this.numLIROperations, basicBlock.getLastLirId() + 2);
        }
    }

    @Override
    public List<Interval> getIntervals() {
        return Collections.unmodifiableList(Arrays.asList(this.intervals));
    }

    @Override
    public ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    @Override
    public int getNumLIROperations() {
        return this.numLIROperations;
    }

    public String toString() {
        return "    Intervals \"" + this.getName() + "\": " + this.intervals.length + " intervals\n";
    }
}

