/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.swing.plaf.LFCustoms;

class ElementResultItem
extends XMLResultItem {
    private static final Color COLOR = new Color(64, 64, 255);
    private final boolean startElement;
    private final boolean empty;
    private GrammarResult res;

    public ElementResultItem(int position, GrammarResult res) {
        super(position, res.getNodeName());
        this.res = res;
        this.foreground = LFCustoms.shiftColor((Color)COLOR);
        this.startElement = true;
        this.empty = res.isEmptyElement();
        this.icon = res.getIcon(1);
    }

    public ElementResultItem(int position, String name) {
        super(position, name);
        this.foreground = LFCustoms.shiftColor((Color)COLOR);
        this.startElement = false;
        this.empty = false;
    }

    @Override
    public String getReplacementText(int modifiers) {
        boolean shift;
        boolean bl = shift = (modifiers & 1) != 0;
        if (shift && this.startElement) {
            if (this.empty) {
                return this.displayText + "/>";
            }
            return this.displayText + ">";
        }
        if (this.startElement) {
            return this.displayText;
        }
        return this.displayText + '>';
    }

    @Override
    public CompletionTask createDocumentationTask() {
        return this.doCreateDocumentationTask(this.res);
    }

    @Override
    public boolean substituteText(JTextComponent c, int offset, int len, int modifiers) {
        boolean shift;
        String replacementText = this.getReplacementText(modifiers);
        this.replaceText(c, replacementText, offset, len);
        boolean bl = shift = (modifiers & 1) != 0;
        if (shift && this.startElement) {
            Caret caret = c.getCaret();
            int dot = caret.getDot();
            int rlen = replacementText.length();
            if (this.empty) {
                caret.setDot(dot - rlen + replacementText.indexOf(47));
            }
        }
        return false;
    }

    @Override
    Color getPaintColor() {
        return LFCustoms.shiftColor((Color)COLOR);
    }
}

