/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.hierarchicallayout;

public class Timing {
    private long lastValue;
    private long sum;
    private String name;

    public Timing(String name) {
        this.name = name;
    }

    public String toString() {
        long val = this.sum;
        if (this.lastValue != 0L) {
            long newValue = System.nanoTime();
            val += newValue - this.lastValue;
        }
        return "Timing for " + this.name + " is: " + val / 1000000L + " ms";
    }

    public void print() {
        System.out.println(this.toString());
    }

    public void start() {
        this.lastValue = System.nanoTime();
    }

    public void stop() {
        if (this.lastValue == 0L) {
            throw new IllegalStateException("You must call start before stop");
        }
        long newValue = System.nanoTime();
        this.sum += newValue - this.lastValue;
        this.lastValue = 0L;
    }
}

