/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.controlflow;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.Serializable;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.controlflow.ControlFlowScene;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ControlFlowTopComponent
extends TopComponent
implements ChangeListener {
    private static ControlFlowTopComponent instance;
    private final GraphViewer viewer = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
    private final ChangeListener wListener = WeakListeners.change((ChangeListener)this, (Object)this.viewer);
    private static final String PREFERRED_ID = "ControlFlowTopComponent";
    private final ControlFlowScene scene;

    private ControlFlowTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ControlFlowTopComponent.class, (String)"CTL_ControlFlowTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ControlFlowTopComponent.class, (String)"HINT_ControlFlowTopComponent"));
        this.scene = new ControlFlowScene();
        this.setLayout(new BorderLayout());
        this.associateLookup(this.scene.getLookup());
        JScrollPane panel = new JScrollPane(this.scene.createView());
        this.add(panel, "Center");
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ControlFlowTopComponent getDefault() {
        if (instance == null) {
            instance = new ControlFlowTopComponent();
        }
        return instance;
    }

    public static synchronized ControlFlowTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find ControlFlow component. It will not be located properly in the window system.");
            return ControlFlowTopComponent.getDefault();
        }
        if (win instanceof ControlFlowTopComponent) {
            return (ControlFlowTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ControlFlowTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ControlFlowTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        super.componentOpened();
        this.viewer.addChangeListener(this.wListener);
    }

    public void componentClosed() {
        this.viewer.removeChangeListener(this.wListener);
        super.componentClosed();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        InputGraphProvider p = this.viewer.getActiveViewer();
        SwingUtilities.invokeLater(() -> this.scene.changeProvider(p));
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void requestActive() {
        super.requestActive();
        this.scene.getView().requestFocus();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ControlFlowTopComponent.getDefault();
        }
    }
}

