/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.controlflow;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.graalvm.visualizer.hierarchicallayout.HierarchicalLayoutManager;
import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.LayoutGraph;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

public class HierarchicalGraphLayout<N, E>
extends GraphLayout<N, E> {
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        LinkedHashSet<LinkWrapper> links = new LinkedHashSet<LinkWrapper>();
        LinkedHashSet<VertexWrapper> vertices = new LinkedHashSet<VertexWrapper>();
        HashMap vertexMap = new HashMap();
        for (Object node : graph.getNodes()) {
            VertexWrapper v = new VertexWrapper(node, graph);
            vertexMap.put(node, v);
            vertices.add(v);
        }
        for (Object edge : graph.getEdges()) {
            Object source = graph.getEdgeSource(edge);
            Object target = graph.getEdgeTarget(edge);
            LinkWrapper l = new LinkWrapper((VertexWrapper)vertexMap.get(source), (VertexWrapper)vertexMap.get(target));
            links.add(l);
        }
        LayoutSettings.LayoutSettingBean layoutSetting = LayoutSettings.getBean();
        boolean decreaseDeviation = (Boolean)layoutSetting.get(Boolean.class, "DECREASE_LAYER_WIDTH_DEVIATION");
        boolean standAlones = (Boolean)layoutSetting.get(Boolean.class, "STANDALONES");
        layoutSetting.set("DECREASE_LAYER_WIDTH_DEVIATION", (Object)false);
        layoutSetting.set("STANDALONES", (Object)false);
        HierarchicalLayoutManager m = new HierarchicalLayoutManager(HierarchicalLayoutManager.Combine.NONE, layoutSetting);
        m.doLayout(new LayoutGraph(links, vertices));
        layoutSetting.set("DECREASE_LAYER_WIDTH_DEVIATION", (Object)decreaseDeviation);
        layoutSetting.set("STANDALONES", (Object)standAlones);
    }

    protected void performNodesLayout(UniversalGraph<N, E> graph, Collection<N> nodes) {
        throw new UnsupportedOperationException();
    }

    private class VertexWrapper
    implements Vertex {
        private N node;
        private UniversalGraph<N, E> graph;
        private final Port slot;
        private Point position;

        public VertexWrapper(N node, UniversalGraph<N, E> graph) {
            this.node = node;
            this.graph = graph;
            this.slot = new Port(){

                public Vertex getVertex() {
                    return VertexWrapper.this;
                }

                public Point getRelativePosition() {
                    return new Point((int)(VertexWrapper.this.getSize().getWidth() / 2.0), (int)(VertexWrapper.this.getSize().getHeight() / 2.0));
                }
            };
            this.position = graph.getScene().findWidget(node).getPreferredLocation();
        }

        public Cluster getCluster() {
            return null;
        }

        public Dimension getSize() {
            Widget w = this.graph.getScene().findWidget(this.node);
            Rectangle bnds = w.getBounds();
            return bnds == null ? new Dimension(0, 0) : bnds.getSize();
        }

        public Point getPosition() {
            return this.position;
        }

        public void setPosition(Point p) {
            HierarchicalGraphLayout.this.setResolvedNodeLocation(this.graph, this.node, p);
            this.position = p;
        }

        public boolean isRoot() {
            return false;
        }

        public int compareTo(Vertex o) {
            VertexWrapper vw = (VertexWrapper)o;
            return this.node.toString().compareTo(vw.node.toString());
        }

        public Port getSlot() {
            return this.slot;
        }

        public boolean isVisible() {
            return true;
        }
    }

    private class LinkWrapper
    implements Link {
        private final VertexWrapper from;
        private final VertexWrapper to;

        public LinkWrapper(VertexWrapper from, VertexWrapper to) {
            this.from = from;
            this.to = to;
        }

        public Port getFrom() {
            return this.from.getSlot();
        }

        public Port getTo() {
            return this.to.getSlot();
        }

        public List<Point> getControlPoints() {
            return new ArrayList<Point>();
        }

        public void setControlPoints(List<Point> list) {
        }

        public boolean isVIP() {
            return false;
        }
    }
}

