/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.difference;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputBlockEdge;
import jdk.graal.compiler.graphio.parsing.model.InputEdge;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import jdk.graal.compiler.graphio.parsing.model.Property;
import org.graalvm.visualizer.data.Pair;
import org.graalvm.visualizer.difference.impl.DiffGraph;

public class Difference {
    public static final String VALUE_NEW = "new";
    public static final String VALUE_CHANGED = "changed";
    public static final String VALUE_SAME = "same";
    public static final String VALUE_DELETED = "deleted";
    public static final String NEW_PREFIX = "NEW_";
    public static final double LIMIT = 100.0;
    public static final String[] IGNORE_PROPERTIES = new String[]{"idx", "debug_idx"};

    public static InputGraph createDiffGraph(InputGraph a, InputGraph b) {
        int argsSize = a.getArgs().length + b.getArgs().length;
        int argsAStartIndex = 0;
        int argsBStartIndex = a.getArgs().length;
        StringBuilder format = new StringBuilder();
        if (a.getDumpId() < 0) {
            format.append(a.getFormat());
        } else {
            format.append("%s: ");
            format.append(a.getFormat());
            ++argsAStartIndex;
            ++argsBStartIndex;
            ++argsSize;
        }
        if (b.getDumpId() < 0) {
            format.append(", ");
            format.append(b.getFormat());
        } else {
            format.append(", %s: ");
            format.append(b.getFormat());
            ++argsBStartIndex;
            ++argsSize;
        }
        Object[] args = new Object[argsSize];
        System.arraycopy(a.getArgs(), 0, args, argsAStartIndex, a.getArgs().length);
        System.arraycopy(b.getArgs(), 0, args, argsBStartIndex, b.getArgs().length);
        if (a.getDumpId() >= 0) {
            args[argsAStartIndex - 1] = a.getDumpId();
        }
        if (b.getDumpId() >= 0) {
            args[argsBStartIndex - 1] = b.getDumpId();
        }
        String id = a.getID().toString() + "/" + b.getID().toString();
        DiffGraph diffGraph = new DiffGraph(id, format.toString(), args, a, b, Difference::completeDiffGraph);
        return Difference.associateGroup(a, b, diffGraph);
    }

    private static DiffGraph completeDiffGraph(InputGraph a, InputGraph b, DiffGraph c) {
        if (a.getGroup() == b.getGroup()) {
            return Difference.createDiffSameGroup(a, b, c);
        }
        return Difference.createDiff(a, b, c);
    }

    private static DiffGraph createDiffSameGroup(InputGraph a, InputGraph b, DiffGraph c) {
        HashMap<Integer, InputNode> keyMapB = new HashMap<Integer, InputNode>(b.getNodes().size());
        for (InputNode n : b.getNodes()) {
            Integer key = n.getId();
            assert (!keyMapB.containsKey(key));
            keyMapB.put(key, n);
        }
        HashSet<NodePair> pairs = new HashSet<NodePair>();
        for (InputNode n : a.getNodes()) {
            Integer key = n.getId();
            if (!keyMapB.containsKey(key)) continue;
            InputNode nB = (InputNode)keyMapB.get(key);
            pairs.add(new NodePair(n, nB));
        }
        return Difference.createDiff(a, b, c, pairs);
    }

    private static DiffGraph associateGroup(InputGraph a, InputGraph b, DiffGraph graph) {
        Group g = new Group(null, null);
        g.setMethod(a.getGroup().getMethod());
        if (a.getGroup() == b.getGroup()) {
            g.getProperties().add(a.getGroup().getProperties());
        } else {
            Properties bps = b.getGroup().getProperties();
            for (Property p : a.getGroup().getProperties()) {
                Object value = p.getValue();
                if (value == null || !value.equals(bps.get(p.getName()))) continue;
                g.getProperties().setProperty(p.getName(), value);
            }
        }
        g.getProperties().setProperty("name", (Object)"Difference");
        g.addElement((FolderElement)graph);
        return graph;
    }

    private static DiffGraph createDiff(InputGraph a, InputGraph b, DiffGraph graph, Set<NodePair> pairs) {
        InputEdge newEdge;
        char toIndex;
        char fromIndex;
        InputNode nodeTo;
        InputNode nodeFrom;
        int to;
        int from;
        Object to2;
        InputBlock from2;
        InputBlock diffblk;
        HashMap<Object, InputBlock> blocksMap = new HashMap<Object, InputBlock>();
        for (Object blk : a.getBlocks()) {
            diffblk = graph.addBlock(blk.getName());
            blocksMap.put(blk, diffblk);
        }
        for (Object blk : b.getBlocks()) {
            diffblk = graph.getBlock(blk.getName());
            if (diffblk == null) {
                diffblk = graph.addBlock(blk.getName());
            }
            blocksMap.put(blk, diffblk);
        }
        HashSet<Pair> aEdges = new HashSet<Pair>();
        for (InputBlockEdge edge : a.getBlockEdges()) {
            aEdges.add(new Pair((Object)edge.getFrom().getName(), (Object)edge.getTo().getName()));
        }
        for (InputBlockEdge bEdge : b.getBlockEdges()) {
            from2 = bEdge.getFrom();
            to2 = bEdge.getTo();
            Pair pair = new Pair((Object)from2.getName(), (Object)to2.getName());
            if (aEdges.contains(pair)) {
                graph.addBlockEdge((InputBlock)blocksMap.get(from2), (InputBlock)blocksMap.get(to2));
                aEdges.remove(pair);
                continue;
            }
            InputBlockEdge edge = graph.addBlockEdge((InputBlock)blocksMap.get(from2), (InputBlock)blocksMap.get(to2));
            edge.setState(InputBlockEdge.State.NEW);
        }
        for (Pair deleted : aEdges) {
            from2 = graph.getBlock((String)deleted.getLeft());
            to2 = graph.getBlock((String)deleted.getRight());
            InputBlockEdge edge = graph.addBlockEdge(from2, (InputBlock)to2);
            edge.setState(InputBlockEdge.State.DELETED);
        }
        HashSet nodesA = new HashSet(a.getNodes());
        HashSet nodesB = new HashSet(b.getNodes());
        HashMap<Object, InputNode> inputNodeMap = new HashMap<Object, InputNode>(pairs.size());
        for (NodePair p : pairs) {
            InputNode n = (InputNode)p.getLeft();
            assert (nodesA.contains(n));
            InputNode nB = (InputNode)p.getRight();
            assert (nodesB.contains(nB));
            nodesA.remove(n);
            nodesB.remove(nB);
            InputNode n2 = new InputNode(n);
            inputNodeMap.put(n, n2);
            inputNodeMap.put(nB, n2);
            graph.addNode(n2);
            InputBlock block = (InputBlock)blocksMap.get(a.getBlock(n));
            block.addNode(n2.getId());
            Difference.markAsChanged(n2, n, nB);
        }
        for (Object n : nodesA) {
            InputNode n2 = new InputNode((InputNode)n);
            graph.addNode(n2);
            InputBlock block = (InputBlock)blocksMap.get(a.getBlock((InputNode)n));
            block.addNode(n2.getId());
            Difference.markAsDeleted(n2);
            inputNodeMap.put(n, n2);
        }
        int curIndex = 0;
        for (InputNode n : nodesB) {
            InputNode n2 = new InputNode(n);
            while (graph.getNode(curIndex) != null) {
                ++curIndex;
            }
            n2.setId(curIndex);
            graph.addNode(n2);
            InputBlock block = (InputBlock)blocksMap.get(b.getBlock(n));
            block.addNode(n2.getId());
            Difference.markAsNew(n2);
            inputNodeMap.put(n, n2);
        }
        Collection edgesA = a.getEdges();
        Collection edgesB = b.getEdges();
        HashSet<InputEdge> newEdges = new HashSet<InputEdge>();
        for (InputEdge e : edgesA) {
            from = e.getFrom();
            to = e.getTo();
            nodeFrom = (InputNode)inputNodeMap.get(a.getNode(from));
            nodeTo = (InputNode)inputNodeMap.get(a.getNode(to));
            fromIndex = e.getFromIndex();
            toIndex = e.getToIndex();
            if (nodeFrom == null || nodeTo == null) {
                System.out.println("Unexpected edge : " + from + " -> " + to);
                continue;
            }
            newEdge = new InputEdge(fromIndex, toIndex, nodeFrom.getId(), nodeTo.getId(), e.getListIndex(), e.getLabel(), e.getType());
            if (newEdges.contains(newEdge)) continue;
            Difference.markAsDeleted(newEdge);
            newEdges.add(newEdge);
            graph.addEdge(newEdge);
        }
        for (InputEdge e : edgesB) {
            from = e.getFrom();
            to = e.getTo();
            nodeFrom = (InputNode)inputNodeMap.get(b.getNode(from));
            nodeTo = (InputNode)inputNodeMap.get(b.getNode(to));
            fromIndex = e.getFromIndex();
            toIndex = e.getToIndex();
            if (nodeFrom == null || nodeTo == null) {
                System.out.println("Unexpected edge : " + from + " -> " + to);
                continue;
            }
            newEdge = new InputEdge(fromIndex, toIndex, nodeFrom.getId(), nodeTo.getId(), e.getListIndex(), e.getLabel(), e.getType());
            if (!newEdges.contains(newEdge)) {
                Difference.markAsNew(newEdge);
                newEdges.add(newEdge);
                graph.addEdge(newEdge);
                continue;
            }
            newEdges.remove(newEdge);
            graph.removeEdge(newEdge);
            Difference.markAsSame(newEdge);
            newEdges.add(newEdge);
            graph.addEdge(newEdge);
        }
        return graph;
    }

    private static DiffGraph createDiff(InputGraph a, InputGraph b, DiffGraph c) {
        HashSet<NodePair> pairs = new HashSet<NodePair>();
        for (InputNode n : a.getNodes()) {
            String s = n.getProperties().getString("name", "");
            for (InputNode n2 : b.getNodes()) {
                String s2 = n2.getProperties().getString("name", "");
                if (!s.equals(s2)) continue;
                NodePair p = new NodePair(n, n2);
                pairs.add(p);
            }
        }
        HashSet<NodePair> selectedPairs = new HashSet<NodePair>();
        while (pairs.size() > 0) {
            double min = Double.MAX_VALUE;
            NodePair minPair = null;
            for (NodePair p : pairs) {
                double cur = p.getValue();
                if (!(cur < min)) continue;
                minPair = p;
                min = cur;
            }
            if (min > 100.0) break;
            selectedPairs.add(minPair);
            HashSet<NodePair> toRemove = new HashSet<NodePair>();
            for (NodePair p : pairs) {
                if (p.getLeft() != minPair.getLeft() && p.getRight() != minPair.getRight()) continue;
                toRemove.add(p);
            }
            pairs.removeAll(toRemove);
        }
        return Difference.createDiff(a, b, c, selectedPairs);
    }

    private static void markAsNew(InputEdge e) {
        e.setState(InputEdge.State.NEW);
    }

    private static void markAsDeleted(InputEdge e) {
        e.setState(InputEdge.State.DELETED);
    }

    private static void markAsSame(InputEdge e) {
        e.setState(InputEdge.State.SAME);
    }

    private static void markAsChanged(InputNode n, InputNode firstNode, InputNode otherNode) {
        Object po;
        boolean difference = false;
        for (Property p : otherNode.getProperties()) {
            po = p.getValue();
            if (Objects.deepEquals(po, firstNode.getProperties().get(p.getName()))) continue;
            difference = true;
            n.getProperties().setProperty(NEW_PREFIX + p.getName(), po);
        }
        for (Property p : firstNode.getProperties()) {
            po = p.getValue();
            if (otherNode.getProperties().get(p.getName()) != null || (po == null ? "" : Objects.toString(po)).length() <= 0) continue;
            difference = true;
            n.getProperties().setProperty(NEW_PREFIX + p.getName(), (Object)"");
        }
        if (difference) {
            n.getProperties().setProperty("state", (Object)VALUE_CHANGED);
        } else {
            n.getProperties().setProperty("state", (Object)VALUE_SAME);
        }
    }

    private static void markAsDeleted(InputNode n) {
        n.getProperties().setProperty("state", (Object)VALUE_DELETED);
    }

    private static void markAsNew(InputNode n) {
        n.getProperties().setProperty("state", (Object)VALUE_NEW);
    }

    private static class NodePair
    extends Pair<InputNode, InputNode> {
        public NodePair(InputNode n1, InputNode n2) {
            super((Object)n1, (Object)n2);
        }

        public double getValue() {
            double result = 0.0;
            for (Property p : ((InputNode)this.getLeft()).getProperties()) {
                double faktor = 1.0;
                for (String forbidden : IGNORE_PROPERTIES) {
                    if (!p.getName().equals(forbidden)) continue;
                    faktor = 0.1;
                    break;
                }
                result += this.evaluate(p.getValue(), ((InputNode)this.getRight()).getProperties().get(p.getName())) * faktor;
            }
            return result;
        }

        private double evaluate(Object p, Object p2) {
            String s2;
            if ((p2 == null || p == null) && p2 != p) {
                return 1.0;
            }
            String s1 = Objects.toString(p);
            if (s1.equals(s2 = Objects.toString(p2))) {
                return 0.0;
            }
            return (double)Math.abs(s1.length() - s2.length()) / (double)s1.length() + 0.5;
        }
    }
}

