/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.bytecodes;

import java.awt.Image;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import jdk.graal.compiler.graphio.parsing.model.InputBytecode;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.bytecodes.SelectBytecodesAction;
import org.graalvm.visualizer.bytecodes.SelectBytecodesCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class BytecodeNode
extends AbstractNode {
    private Set<InputNode> nodes;

    public BytecodeNode(InputBytecode bytecode, InputGraph graph, String bciValue) {
        super(Children.LEAF);
        String displayName = bytecode.getBci() + " " + bytecode.getName() + " " + bytecode.getOperands();
        bciValue = bytecode.getBci() + " " + (String)bciValue;
        bciValue = ((String)bciValue).trim();
        Properties.PropertySelector selector = new Properties.PropertySelector(graph.getNodes());
        Properties.EqualityPropertyMatcher matcher = new Properties.EqualityPropertyMatcher("bci", bciValue);
        List nodeList = selector.selectMultiple((Properties.PropertyMatcher)matcher);
        if (nodeList.size() > 0) {
            this.nodes = new LinkedHashSet<InputNode>();
            for (InputNode n : nodeList) {
                this.nodes.add(n);
            }
            displayName = displayName + " (" + this.nodes.size() + " nodes)";
        }
        if (bytecode.getComment() != null) {
            displayName = displayName + " // " + bytecode.getComment();
        }
        this.setDisplayName(displayName);
    }

    public Image getIcon(int i) {
        if (this.nodes != null) {
            return ImageUtilities.loadImage((String)"org/graalvm/visualizer/bytecodes/images/link.png");
        }
        return ImageUtilities.loadImage((String)"org/graalvm/visualizer/bytecodes/images/bytecode.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean b) {
        return new Action[]{(Action)SelectBytecodesAction.findObject(SelectBytecodesAction.class, (boolean)true)};
    }

    public Action getPreferredAction() {
        return (Action)SelectBytecodesAction.findObject(SelectBytecodesAction.class, (boolean)true);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> aClass) {
        if (aClass == SelectBytecodesCookie.class && this.nodes != null) {
            return (T)new SelectBytecodesCookie(this.nodes);
        }
        return (T)super.getCookie(aClass);
    }
}

