/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.bytecodes;

import java.awt.Image;
import java.util.Collections;
import jdk.graal.compiler.graphio.parsing.model.InputBytecode;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputMethod;
import org.graalvm.visualizer.bytecodes.BytecodeNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class MethodNode
extends AbstractNode {
    public MethodNode(InputMethod method, InputGraph graph, String bciString) {
        super((Children)(method != null && method.getBytecodes().isEmpty() ? Children.LEAF : new MethodNodeChildren(method, graph, bciString)));
        if (method != null) {
            this.setDisplayName(method.getName());
        }
    }

    public Image getIcon(int i) {
        return ImageUtilities.loadImage((String)"org/graalvm/visualizer/bytecodes/images/method.png");
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public void update(InputGraph graph, InputMethod method) {
        ((MethodNodeChildren)this.getChildren()).setMethod(method, graph);
        if (method != null) {
            this.setDisplayName(method.getName());
        }
    }

    private static class MethodNodeChildren
    extends Children.Keys<InputBytecode> {
        private InputMethod method;
        private InputGraph graph;
        private final String bciString;

        public MethodNodeChildren(InputMethod method, InputGraph graph, String bciString) {
            this.method = method;
            this.bciString = bciString;
            this.graph = graph;
        }

        protected Node[] createNodes(InputBytecode bc) {
            if (bc.getInlined() == null) {
                return new Node[]{new BytecodeNode(bc, this.graph, this.bciString)};
            }
            return new Node[]{new BytecodeNode(bc, this.graph, this.bciString), new MethodNode(bc.getInlined(), this.graph, bc.getBci() + " " + this.bciString)};
        }

        public void addNotify() {
            this.setKeys(this.method == null ? Collections.emptyList() : this.method.getBytecodes());
        }

        public void setMethod(InputMethod method, InputGraph graph) {
            this.method = method;
            this.graph = graph;
            this.addNotify();
        }
    }
}

