/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.queries;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class GradleSourceForBinary
implements SourceForBinaryQueryImplementation2 {
    private static final String GRADLE_JAR_PREFIX = "gradle-";
    private final Map<URL, Res> cache = new HashMap<URL, Res>();

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        Res ret = this.cache.get(binaryRoot);
        GradleDistributionManager.GradleDistribution dist = GradleDistributionManager.get(GradleSettings.getDefault().getGradleUserHome()).defaultDistribution();
        if (ret == null && dist.isAvailable()) {
            FileObject srcDir;
            FileObject distDir = FileUtil.toFileObject((File)dist.getDistributionDir());
            FileObject fileObject = srcDir = distDir == null ? null : distDir.getFileObject("src");
            if (srcDir != null && "jar".equals(binaryRoot.getProtocol())) {
                try {
                    FileObject jarSrc;
                    String srcName;
                    FileObject jar;
                    URI uri = FileUtil.getArchiveFile((URL)binaryRoot).toURI();
                    if ("file".equals(uri.getScheme()) && (jar = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)Utilities.toFile((URI)uri)))) != null && FileUtil.isParentOf((FileObject)distDir, (FileObject)jar) && (srcName = jar.getName()).startsWith(GRADLE_JAR_PREFIX) && (jarSrc = srcDir.getFileObject(srcName = srcName.substring(GRADLE_JAR_PREFIX.length(), srcName.lastIndexOf(45)))) != null) {
                        ret = new Res(jarSrc);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (ret != null) {
                this.cache.put(binaryRoot, ret);
            }
        }
        return ret;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    public static class Res
    implements SourceForBinaryQueryImplementation2.Result {
        private final FileObject[] ret;

        public Res(FileObject fo) {
            this.ret = new FileObject[]{fo};
        }

        public boolean preferSources() {
            return false;
        }

        public FileObject[] getRoots() {
            return this.ret;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

