/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.difference.Difference;
import org.graalvm.visualizer.util.LookupHistory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class DiffGraphCookie
implements Node.Cookie {
    private final InputGraph graph;

    public DiffGraphCookie(InputGraph graph) {
        this.graph = graph;
    }

    private InputGraph getCurrentGraph() {
        InputGraphProvider graphProvider = (InputGraphProvider)LookupHistory.getLast(InputGraphProvider.class);
        if (graphProvider != null) {
            return graphProvider.getGraph();
        }
        return null;
    }

    public boolean isPossible() {
        InputGraph cg = this.getCurrentGraph();
        if (cg == null || cg == this.graph || !Objects.equals(cg.getGraphType(), this.graph.getGraphType())) {
            return false;
        }
        Group p1 = this.graph.getGroup();
        Group p2 = cg.getGroup();
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.getOwner() != null && p2.getOwner() != null;
    }

    public void openDiff() {
        if (!this.isPossible()) {
            return;
        }
        InputGraph other = this.getCurrentGraph();
        GraphViewer viewer = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
        if (viewer != null) {
            InputGraph diffGraph = Difference.createDiffGraph((InputGraph)other, (InputGraph)this.graph);
            viewer.view(diffGraph, true, new Object[0]);
        }
    }
}

