/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import org.graalvm.visualizer.coordinator.actions.Bundle;
import org.graalvm.visualizer.coordinator.actions.SaveAsAction;
import org.graalvm.visualizer.coordinator.actions.SaveOperation;
import org.graalvm.visualizer.coordinator.actions.SaveOptions;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.openide.awt.StatusDisplayer;

class SaveActionPerformer {
    final SaveOperation oper;
    final GraalSettings settings = GraalSettings.obtain();
    final FileFilter ff = SaveAsAction.getFileFilter();

    public SaveActionPerformer(SaveOperation operation) {
        this.oper = operation;
    }

    void doSave() {
        this.oper.prepare();
        this.oper.saveFileBoundSessions();
        if (this.oper.isFinished()) {
            StatusDisplayer.getDefault().setStatusText(this.oper.getDocumentsSaved() == 0 ? Bundle.STATUS_NoSessionModified() : Bundle.STATUS_AllDocumentsSaved());
            return;
        }
        SaveOptions sopts = new SaveOptions();
        sopts.configure(this.oper);
        GraphDocument first = this.oper.firstDocumentToSave();
        Path p = this.promptDocumentPath(sopts, null, first);
        if (p == null) {
            return;
        }
        File file = p.toFile();
        this.oper.setSaveStyle(sopts.getStyle());
        this.oper.setUserPath(this.oper.getUsableFileName(file.toPath(), false));
        this.oper.setUserTitle(sopts.getFileComment());
        if (sopts.isPromptEachFile()) {
            this.oper.setPathProvider(this::promptDocumentPath);
        }
        this.oper.execute();
    }

    private Path promptDocumentPath(Path suggested, GraphDocument doc) {
        SaveOptions sopts = new SaveOptions();
        sopts.makeFilePrompt();
        return this.promptDocumentPath(sopts, suggested, doc);
    }

    private Path promptDocumentPath(SaveOptions sopts, Path suggested, GraphDocument doc) {
        String t;
        JFileChooser fc = this.newFileChooser();
        if (suggested != null) {
            t = this.oper.isSaveAs() ? Bundle.TITLE_SaveSingleAs() : Bundle.TITLE_SaveSingle();
            fc.setSelectedFile(suggested.toFile());
        } else {
            t = this.oper.isSaveAs() ? (this.oper.hasMultipleSessions() ? Bundle.TITLE_SaveAsMultiple() : Bundle.TITLE_SaveAs()) : (this.oper.hasMultipleSessions() ? Bundle.TITLE_SaveMultiple() : Bundle.TITLE_Save());
        }
        fc.setDialogTitle(t);
        if (doc != null) {
            String n = doc.getName();
            String l = doc.getProperties().getString("igv.userLabel", null);
            if (this.oper.getFile(doc) == null) {
                fc.setSelectedFile(this.oper.getUsableFileName(Paths.get(n, new String[0]), true).toFile());
            } else if (suggested == null) {
                fc.setSelectedFile(this.oper.getUsableFileName(Paths.get(n, new String[0]), this.oper.isSaveAs()).toFile());
            }
            if (l != null) {
                sopts.setFileComment(l);
            }
        }
        fc.setAccessory(sopts);
        if (fc.showSaveDialog(null) != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        this.settings.setDirectory(fc.getCurrentDirectory().getAbsolutePath());
        if (!this.ff.accept(file)) {
            file = this.oper.getUsableFileName(file);
        }
        return file.toPath();
    }

    private JFileChooser newFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(this.ff);
        fc.setCurrentDirectory(new File(this.settings.getDirectory()));
        return fc;
    }
}

