/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.graalvm.visualizer.coordinator.actions.SaveOperation;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SaveOptions
extends JPanel {
    private JCheckBox cbPromptNames;
    private JLabel jLabel2;
    private JLabel lFileComment;
    private JRadioButton optCollectGroups;
    private JRadioButton optMultipleFiles;
    private JRadioButton optRetainSessions;
    private ButtonGroup saveStyle;
    private JTextField tFileComment;

    public SaveOptions() {
        this.initComponents();
    }

    public void configure(SaveOperation so) {
        if (!so.hasMultipleSessions()) {
            this.makeSingleSession();
            return;
        }
        if (so.isSaveAs() && !so.hasGroups()) {
            this.optCollectGroups.setEnabled(false);
            this.optRetainSessions.setSelected(true);
        }
        this.tFileComment.setText(so.getInitialFileComment());
        this.updateFileComment();
    }

    public void setFileComment(String fileComment) {
        this.tFileComment.setText(fileComment);
    }

    public boolean isPromptEachFile() {
        return this.optMultipleFiles.isSelected() && this.cbPromptNames.isSelected();
    }

    public String getFileComment() {
        if (this.tFileComment.isEnabled()) {
            return this.tFileComment.getText();
        }
        return null;
    }

    private void updateFileComment() {
        this.cbPromptNames.setEnabled(this.optMultipleFiles.isSelected());
        boolean enable = !this.optMultipleFiles.isSelected() || this.cbPromptNames.isSelected();
        this.tFileComment.setEnabled(enable);
        this.lFileComment.setEnabled(enable);
    }

    public SaveOperation.Style getStyle() {
        if (this.optRetainSessions.isSelected()) {
            return SaveOperation.Style.SESSIONS;
        }
        if (this.optCollectGroups.isSelected()) {
            return SaveOperation.Style.GROUPS;
        }
        if (this.optMultipleFiles.isSelected()) {
            return SaveOperation.Style.FILES;
        }
        return SaveOperation.Style.SESSIONS;
    }

    private void initComponents() {
        this.saveStyle = new ButtonGroup();
        this.lFileComment = new JLabel();
        this.tFileComment = new JTextField();
        this.jLabel2 = new JLabel();
        this.optRetainSessions = new JRadioButton();
        this.optCollectGroups = new JRadioButton();
        this.optMultipleFiles = new JRadioButton();
        this.cbPromptNames = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.lFileComment, (String)NbBundle.getMessage(SaveOptions.class, (String)"SaveOptions.lFileComment.text"));
        this.tFileComment.setText(NbBundle.getMessage(SaveOptions.class, (String)"SaveOptions.tFileComment.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SaveOptions.class, (String)"SaveOptions.jLabel2.text"));
        this.saveStyle.add(this.optRetainSessions);
        Mnemonics.setLocalizedText((AbstractButton)this.optRetainSessions, (String)NbBundle.getMessage(SaveOptions.class, (String)"SaveOptions.optRetainSessions.text"));
        this.saveStyle.add(this.optCollectGroups);
        this.optCollectGroups.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.optCollectGroups, (String)NbBundle.getMessage(SaveOptions.class, (String)"SaveOptions.optCollectGroups.text"));
        this.saveStyle.add(this.optMultipleFiles);
        Mnemonics.setLocalizedText((AbstractButton)this.optMultipleFiles, (String)NbBundle.getMessage(SaveOptions.class, (String)"SaveOptions.optMultipleFiles.text"));
        this.optMultipleFiles.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SaveOptions.this.optMultipleFilesItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbPromptNames, (String)NbBundle.getMessage(SaveOptions.class, (String)"SaveOptions.cbPromptNames.text"));
        this.cbPromptNames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SaveOptions.this.cbPromptNamesItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tFileComment).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lFileComment).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(48, 48, 48).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optCollectGroups).addComponent(this.optRetainSessions).addComponent(this.optMultipleFiles).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.cbPromptNames)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.optRetainSessions)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optCollectGroups).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optMultipleFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPromptNames).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lFileComment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tFileComment, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void optMultipleFilesItemStateChanged(ItemEvent evt) {
        this.updateFileComment();
    }

    private void cbPromptNamesItemStateChanged(ItemEvent evt) {
        this.updateFileComment();
    }

    public void makeFilePrompt() {
        this.optMultipleFiles.setSelected(true);
        this.cbPromptNames.setSelected(true);
        this.optCollectGroups.setEnabled(false);
        this.optMultipleFiles.setEnabled(false);
        this.optRetainSessions.setEnabled(false);
        this.cbPromptNames.setEnabled(false);
        this.lFileComment.setEnabled(true);
        this.tFileComment.setEnabled(true);
    }

    public void makeSingleSession() {
        this.optCollectGroups.setEnabled(false);
        this.optMultipleFiles.setEnabled(false);
        this.optRetainSessions.setEnabled(false);
        this.cbPromptNames.setEnabled(false);
        this.updateFileComment();
    }
}

