/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.graalvm.visualizer.coordinator.impl.Bundle;
import org.graalvm.visualizer.coordinator.impl.FileImporter;
import org.netbeans.api.actions.Openable;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.Exceptions;

public class BinaryGraphDataObject
extends MultiDataObject {
    private static final Logger LOG = Logger.getLogger(BinaryGraphDataObject.class.getName());
    public static final String GRAAL_DUMP_MIME_TYPE = "application/x-graalvm-graph-binary";

    public BinaryGraphDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        this.getCookieSet().assign(Openable.class, (Object[])new Openable[]{new OpenImpl()});
    }

    public void importPrimaryFile() {
        FileObject fo = this.getPrimaryFile();
        File f = FileUtil.toFile((FileObject)fo);
        if (f == null) {
            return;
        }
        try {
            Thread.dumpStack();
            FileImporter.asyncImportDocument(f.toPath(), true, true, null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)ex, (String)Bundle.ERR_OpeningFile(f.toPath(), ex.toString())));
        }
    }

    private class OpenImpl
    implements OpenCookie {
        private OpenImpl() {
        }

        public void open() {
            BinaryGraphDataObject.this.importPrimaryFile();
        }
    }
}

