/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.DocumentFactory;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.connection.Server;
import org.graalvm.visualizer.coordinator.impl.Bundle;
import org.graalvm.visualizer.coordinator.impl.ManagedSessionImpl;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.netbeans.api.io.IOProvider;
import org.netbeans.api.io.InputOutput;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class SessionManagerImpl
implements Folder,
Runnable,
DocumentFactory {
    private static SessionManagerImpl INSTANCE;
    private final GraphDocument singleDocument = new ManagedSessionImpl(null);
    private Server binaryServer;
    private final List<GraphDocument> sessions = new ArrayList<GraphDocument>();
    private final ChangedEvent<SessionManagerImpl> changedEvent = new ChangedEvent((Object)this);
    private final Set<GraphDocument> closedDocuments = new WeakSet();
    private volatile boolean separateSessions;
    private List<DocumentFactory> factories;

    public SessionManagerImpl() {
        INSTANCE = this;
        this.separateSessions = (Boolean)GraalSettings.obtain().get(Boolean.class, "autoSeparateSessions");
        this.singleDocument.getProperties().setProperty("name", (Object)Bundle.LABEL_DefaultDocumentName());
    }

    GraphDocument getSingleDocument() {
        return this.singleDocument;
    }

    public Object getID() {
        return "<session-manager>";
    }

    public List<? extends FolderElement> getElements() {
        return this.getSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(FolderElement element) {
        if (!(element instanceof GraphDocument)) {
            throw new IllegalArgumentException();
        }
        GraphDocument gd = (GraphDocument)element;
        SessionManagerImpl sessionManagerImpl = this;
        synchronized (sessionManagerImpl) {
            if (!this.sessions.remove(gd)) {
                return;
            }
            this.closedDocuments.remove(gd);
        }
        this.changedEvent.fire();
    }

    public void addElement(FolderElement group) {
        if (!(group instanceof GraphDocument)) {
            throw new IllegalArgumentException();
        }
        this.addSession((GraphDocument)group);
    }

    public ChangedEvent<SessionManagerImpl> getChangedEvent() {
        return this.changedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParentOf(FolderElement child) {
        GraphDocument owner = child.getOwner();
        SessionManagerImpl sessionManagerImpl = this;
        synchronized (sessionManagerImpl) {
            return this.sessions.contains(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphDocument> getSessions() {
        SessionManagerImpl sessionManagerImpl = this;
        synchronized (sessionManagerImpl) {
            return new ArrayList<GraphDocument>(this.sessions);
        }
    }

    public List<GraphDocument> getAppendableSessions() {
        List<GraphDocument> s = this.getSessions();
        s.removeAll(this.getUnappendableDocuments());
        return s;
    }

    private static FileObject getAssociatedFile(GraphDocument gd) {
        if (!(gd instanceof Lookup.Provider)) {
            return null;
        }
        Lookup.Provider lp = (Lookup.Provider)gd;
        return (FileObject)lp.getLookup().lookup(FileObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(GraphDocument session) {
        SessionManagerImpl sessionManagerImpl = this;
        synchronized (sessionManagerImpl) {
            if (this.sessions.contains(session)) {
                return;
            }
            this.sessions.add(session);
            if (SessionManagerImpl.getAssociatedFile(session) != null) {
                this.closedDocuments.add(session);
            }
        }
        this.changedEvent.fire();
    }

    synchronized Collection<GraphDocument> getUnappendableDocuments() {
        return new ArrayList<GraphDocument>(this.closedDocuments);
    }

    public synchronized void freezeCurrentDocuments() {
        this.closedDocuments.addAll(this.getSessions());
    }

    @Override
    public void run() {
        this.binaryServer = new SImpl(this, new ParseMonitor(){

            public void updateProgress() {
            }

            public void setState(String state) {
            }

            public boolean isCancelled() {
                return false;
            }

            public void reportError(List<FolderElement> parents, List<String> parentNames, String name, String errorMessage) {
                SessionManagerImpl.reportLoadingError(parents, parentNames, name, errorMessage);
            }
        });
    }

    public static SessionManagerImpl getInstance() {
        return INSTANCE;
    }

    public GraphDocument getCurrentDocument() {
        boolean a = true;
        boolean b = false;
        a = !b;
        return this.singleDocument;
    }

    public static void reportLoadingError(List<FolderElement> parents, List<String> parentNames, String name, String errorMessage) {
        if (parentNames == null) {
            // empty if block
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parentNames.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(Bundle.WARNING_ErrorDuringLoadSeparator());
            }
            FolderElement p = null;
            if (i < parents.size()) {
                p = parents.get(i);
            }
            if (p != null) {
                sb.append(p.getName());
                continue;
            }
            sb.append(parentNames.get(i));
        }
        if (sb.length() > 0) {
            sb.append(Bundle.WARNING_ErrorDuringLoadSeparator());
            sb.append(name);
        }
        InputOutput io = IOProvider.getDefault().getIO(Bundle.TITLE_ErrorLoadingData(), false);
        io.show();
        PrintWriter pw = new PrintWriter((Writer)io.getErr());
        pw.println(Bundle.WARNING_ErrorDuringLoadTitle(sb.toString()));
        pw.println(Bundle.WARNING_ErrorDuringLoadMessage(errorMessage));
        pw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDocument documentFor(Object id, Properties props, Group g) {
        SessionManagerImpl sessionManagerImpl = this;
        synchronized (sessionManagerImpl) {
            if (this.factories == null) {
                this.factories = new ArrayList<DocumentFactory>(Lookup.getDefault().lookupAll(DocumentFactory.class));
            }
        }
        for (DocumentFactory f : this.factories) {
            GraphDocument gd = f.documentFor(id, props, g);
            if (gd == null) continue;
            return gd;
        }
        GraphDocument doc = this.getSingleDocument();
        if (doc != null) {
            this.addSession(doc);
        }
        return doc;
    }

    public Folder getParent() {
        return null;
    }

    public String getName() {
        return null;
    }

    public void setParent(Folder parent) {
    }

    public String getSessionDisplayName(GraphDocument doc) {
        return this.getSessionDisplayName(doc, true);
    }

    public String getSessionDisplayName(GraphDocument doc, boolean annotate) {
        if (doc == null) {
            return null;
        }
        FileObject f = SessionManagerImpl.getAssociatedFile(doc);
        Properties docProperties = doc.getProperties();
        String name = docProperties.getString("name", null);
        if (name != null && name.isEmpty()) {
            name = null;
        }
        String label = docProperties.getString("igv.userLabel", null);
        if (name == null) {
            String id = docProperties.getString("vm.uuid", null);
            if (id == null) {
                String compilationId = docProperties.getString("truffle.compilation.id", null);
                if (compilationId == null) {
                    compilationId = docProperties.getString("compilationId", null);
                }
                name = compilationId != null ? compilationId : Bundle.FMT_SessionDumpName(Integer.toHexString(System.identityHashCode(doc)));
            } else {
                name = Bundle.FMT_SessionDumpName(id);
            }
        }
        if (!annotate) {
            return label != null ? label : name;
        }
        if (f != null) {
            if (label == null) {
                if (f.getName().equals(name)) {
                    return f.getNameExt();
                }
                return Bundle.FMT_SessionFileName(name, f.getNameExt());
            }
            return Bundle.FMT_SessionLabelFile(label, f.getNameExt());
        }
        if (label != null) {
            return label;
        }
        String dateTime = docProperties.getString("date", null);
        if (dateTime == null) {
            return name;
        }
        return Bundle.FMT_SessionSynthetic(name, dateTime);
    }

    public String getSessionName(GraphDocument doc, boolean fillDefault) {
        String name = doc.getName();
        String label = doc.getProperties().getString("igv.userLabel", null);
        if (label != null || fillDefault) {
            return label;
        }
        return name;
    }

    public void attachFile(GraphDocument doc, FileObject file) {
        if (!(doc instanceof ManagedSessionImpl)) {
            throw new IllegalArgumentException();
        }
        ManagedSessionImpl session = (ManagedSessionImpl)doc;
        session.setSaveAs(file);
    }

    public boolean isSeparateSessions() {
        return this.separateSessions;
    }

    public void setSeparateSessions(boolean separateSessions) {
        this.separateSessions = separateSessions;
    }

    class SImpl
    extends Server
    implements Runnable {
        RequestProcessor.Task scheduledSessionClose;

        public SImpl(DocumentFactory rootDocumentFactory, ParseMonitor monitor) {
            super(rootDocumentFactory, monitor);
        }

        protected synchronized void onAllClientsClosed() {
            super.onAllClientsClosed();
            if (this.scheduledSessionClose != null && !this.scheduledSessionClose.cancel()) {
                return;
            }
            if (SessionManagerImpl.this.separateSessions) {
                this.scheduledSessionClose = RequestProcessor.getDefault().post((Runnable)this, (Integer)GraalSettings.obtain().get(Integer.class, "sessionCloseTimeout") * 1000);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DocumentFactory onNewClient() {
            SImpl sImpl = this;
            synchronized (sImpl) {
                if (this.scheduledSessionClose != null) {
                    this.scheduledSessionClose.cancel();
                }
                this.scheduledSessionClose = null;
            }
            return SessionManagerImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SImpl sImpl = this;
            synchronized (sImpl) {
                if (this.scheduledSessionClose == null) {
                    return;
                }
                this.scheduledSessionClose = null;
            }
            SessionManagerImpl.this.freezeCurrentDocuments();
        }
    }
}

