/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.hints.pom.Bundle;
import org.netbeans.modules.maven.hints.pom.MavenResult;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.SelectionPOMFixProvider;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Parent;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class MavenSelectionHintsTask
extends ParserResultTask<MavenResult> {
    public void run(MavenResult result, SchedulerEvent event) {
        int se;
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        CursorMovedSchedulerEvent cursorEvent = (CursorMovedSchedulerEvent)event;
        int ss = cursorEvent.getCaretOffset();
        if (ss > (se = cursorEvent.getMarkOffset())) {
            int x = se;
            se = ss;
            ss = x;
        }
        List<ErrorDescription> errors = MavenSelectionHintsTask.computeErrors(result, ss, se, cursorEvent.getCaretOffset());
        HintsController.setErrors((FileObject)result.getPomFile(), (String)"pom-selection", errors);
    }

    @NonNull
    static List<ErrorDescription> computeErrors(MavenResult result, int ss, int se, int co) {
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        FileObject fo = result.getPomFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        Document document = result.getSnapshot().getSource().getDocument(false);
        if (fo == null || project == null || project.getProjectDirectory() != fo.getParent()) {
            return errors;
        }
        POMModel model = result.getProjectModel();
        StyledDocument styled = null;
        Annotation[] old = null;
        if (document instanceof StyledDocument) {
            styled = (StyledDocument)document;
            old = (Annotation[])styled.getProperty("maven_annot");
        }
        if (PomModelUtils.checkModelValid(model)) {
            for (SelectionPOMFixProvider prov : PomModelUtils.hintProviders(project, SelectionPOMFixProvider.class)) {
                List<ErrorDescription> lst = prov.getErrorsForDocument(model, project, ss, se, co);
                if (lst == null) continue;
                errors.addAll(lst);
            }
            if (styled != null) {
                ArrayList<ParentPomAnnotation> anns = new ArrayList<ParentPomAnnotation>();
                try {
                    Parent p = (Parent)model.findComponent(ss, Parent.class, true);
                    if (p != null && p.getArtifactId() != null && p.getGroupId() != null && p.getVersion() != null) {
                        ParentPomAnnotation ann = new ParentPomAnnotation();
                        anns.add(ann);
                        Position position = NbDocument.createPosition((Document)document, (int)ss, (Position.Bias)Position.Bias.Forward);
                        NbDocument.addAnnotation((StyledDocument)styled, (Position)position, (int)(se - ss), (Annotation)ann);
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (old != null) {
                    // empty if block
                }
                styled.putProperty("maven_annot", anns.toArray(Annotation[]::new));
            } else if (styled != null) {
                styled.putProperty("maven_annot", null);
            }
            if (styled != null && old != null) {
                for (Annotation ann : old) {
                    NbDocument.removeAnnotation((StyledDocument)styled, (Annotation)ann);
                }
            }
        }
        return errors;
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public static class ParentPomAnnotation
    extends Annotation {
        public String getAnnotationType() {
            return "org-netbeans-modules-editor-annotations-implements";
        }

        public String getShortDescription() {
            return Bundle.ParentPOMAnnotation_Description();
        }
    }
}

