/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.Source;
import org.graalvm.visualizer.graph.Block;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.DiagramItem;
import org.graalvm.visualizer.graph.FigureSource;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;
import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.Vertex;

public class Figure
extends Properties.Entity
implements Source.Provider,
Vertex,
DiagramItem {
    public static final int INSET = 8;
    public static int SLOT_WIDTH = 10;
    public static final int OVERLAPPING = 6;
    public static final int SLOT_START = 4;
    public static final int SLOT_OFFSET = 8;
    protected ArrayList<InputSlot> inputSlots;
    private OutputSlot singleOutput;
    private ArrayList<OutputSlot> outputSlots;
    private final Source source;
    private final Diagram diagram;
    private Point position;
    private final ArrayList<Figure> predecessors;
    private final ArrayList<Figure> successors;
    private List<InputGraph> subgraphs;
    private Color color;
    private final int id;
    private final String idString;
    private String[] lines;
    private int heightCache = -1;
    private int widthCache = -1;
    private final int hash;
    private boolean boundary;
    private boolean deleted;
    private boolean visible;
    Boolean isRoot;

    void setDeleted() {
        this.deleted = true;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    void clear() {
        assert (this.isDeleted()) : this;
        if (this.inputSlots != null) {
            this.inputSlots.clear();
        }
        if (this.outputSlots != null) {
            this.outputSlots.clear();
        }
        if (this.predecessors != null) {
            this.predecessors.clear();
        }
        if (this.successors != null) {
            this.successors.clear();
        }
    }

    public void updateDimensions(Figure f) {
        this.setPosition(f.getPosition());
        if (f.heightCache >= 0) {
            this.heightCache = f.heightCache;
        }
        if (f.widthCache >= 0) {
            this.widthCache = f.widthCache;
        }
    }

    public int getHeight() {
        if (this.heightCache == -1) {
            BufferedImage image = new BufferedImage(1, 1, 1);
            Graphics g = image.getGraphics();
            g.setFont(Diagram.getFont().deriveFont(1));
            FontMetrics metrics = g.getFontMetrics();
            String nodeText = this.diagram.getNodeText();
            this.heightCache = nodeText.split("\n").length * metrics.getHeight() + 8;
        }
        return this.heightCache;
    }

    public static <T> List<T> getAllBefore(List<T> inputList, T tIn) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : inputList) {
            if (t.equals(tIn)) break;
            result.add(t);
        }
        return result;
    }

    public static int getSlotsWidth(Collection<? extends Slot> slots) {
        int result = 8;
        for (Slot slot : slots) {
            result += slot.getWidth() + 8;
        }
        return result;
    }

    public int getSlotsWidthBefore(InputSlot inputSlot) {
        int result = 8;
        for (Slot slot : this.inputSlots) {
            if (slot == inputSlot) {
                return result;
            }
            result += slot.getWidth() + 8;
        }
        return result;
    }

    public static int getSlotsWidth(Slot s) {
        if (s == null) {
            return 8;
        }
        return 8 + s.getWidth() + 8;
    }

    public int getWidth() {
        if (this.widthCache == -1) {
            int max = 0;
            BufferedImage image = new BufferedImage(1, 1, 1);
            Graphics g = image.getGraphics();
            g.setFont(Diagram.getFont().deriveFont(1));
            FontMetrics metrics = g.getFontMetrics();
            for (String s : this.getLines()) {
                int cur = metrics.stringWidth(s);
                if (cur <= max) continue;
                max = cur;
            }
            this.widthCache = max + 8;
            this.widthCache = Math.max(this.widthCache, Figure.getSlotsWidth(this.inputSlots));
            this.widthCache = Math.max(this.widthCache, this.outputSlots == null ? Figure.getSlotsWidth(this.singleOutput) : Figure.getSlotsWidth(this.outputSlots));
        }
        return this.widthCache;
    }

    protected Figure(Diagram diagram, int id) {
        this.diagram = diagram;
        this.source = new FigureSource(this);
        this.inputSlots = new ArrayList(5);
        this.predecessors = new ArrayList(6);
        this.successors = new ArrayList(6);
        this.id = id;
        this.idString = Integer.toString(id);
        this.position = new Point(0, 0);
        this.color = Color.WHITE;
        this.hash = diagram.hashCode() * 83 + id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Figure)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Figure f = (Figure)obj;
        return f.getDiagram() == this.diagram && f.getId() == this.id;
    }

    public int hashCode() {
        return this.hash;
    }

    public int getId() {
        return this.id;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public List<Figure> getPredecessors() {
        return Collections.unmodifiableList(this.predecessors);
    }

    public Set<Figure> getPredecessorSet() {
        HashSet<Figure> result = new HashSet<Figure>();
        for (Figure f : this.getPredecessors()) {
            result.add(f);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Figure> getSuccessorSet() {
        HashSet<Figure> result = new HashSet<Figure>();
        for (Figure f : this.getSuccessors()) {
            result.add(f);
        }
        return Collections.unmodifiableSet(result);
    }

    public List<Figure> getSuccessors() {
        return Collections.unmodifiableList(this.successors);
    }

    protected void addPredecessor(Figure f) {
        this.predecessors.add(f);
    }

    protected void addSuccessor(Figure f) {
        this.successors.add(f);
    }

    public void cleanDeletedFigures() {
        this.predecessors.removeIf(Figure::isDeleted);
        this.successors.removeIf(Figure::isDeleted);
    }

    protected void removePredecessor(Figure f) {
        assert (this.predecessors.contains(f));
        this.predecessors.remove(f);
    }

    protected void removeSuccessor(Figure f) {
        assert (this.successors.contains(f));
        this.successors.remove(f);
    }

    public List<InputGraph> getSubgraphs() {
        return this.subgraphs;
    }

    public void setSubgraphs(List<InputGraph> subgraphs) {
        this.subgraphs = subgraphs;
    }

    @Override
    public void setPosition(Point p) {
        this.position = p;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public Source getSource() {
        return this.source;
    }

    public InputSlot createInputSlot() {
        InputSlot slot = new InputSlot(this, -1);
        this.inputSlots.add(slot);
        slot.setPosition(this.inputSlots.size() - 1);
        return slot;
    }

    public InputSlot createInputSlot(int index) {
        InputSlot slot = new InputSlot(this, index);
        this.inputSlots.add(slot);
        Collections.sort(this.inputSlots, Slot.slotIndexComparator);
        this.assignPositions(this.inputSlots);
        return slot;
    }

    public void removeSlot(Slot s) {
        assert (this.inputSlots.contains(s) || this.singleOutput == s || this.outputSlots != null && this.outputSlots.contains(s));
        ArrayList<Connection> connections = new ArrayList<Connection>(s.getConnections());
        for (Connection c : connections) {
            c.remove();
        }
        if (this.inputSlots.contains(s)) {
            this.inputSlots.remove(s);
            this.assignPositions(this.inputSlots);
        } else if (!this.doRemoveOutputSlot(s)) {
            return;
        }
        this.sourcesChanged(s.getSource());
    }

    private boolean doRemoveOutputSlot(Slot s) {
        if (this.outputSlots != null) {
            boolean ret = this.outputSlots.remove(s);
            if (this.outputSlots.isEmpty()) {
                this.outputSlots = null;
                this.singleOutput = null;
            } else if (this.outputSlots.size() == 1) {
                this.singleOutput = this.outputSlots.get(0);
                this.singleOutput.setPosition(0);
                this.outputSlots = null;
            } else {
                this.assignPositions(this.outputSlots);
            }
            return ret;
        }
        if (this.singleOutput == s) {
            this.singleOutput = null;
            return true;
        }
        return false;
    }

    public OutputSlot createOutputSlot() {
        OutputSlot slot = new OutputSlot(this, -1);
        if (this.addOutputSlot(slot)) {
            this.assignPositions(this.outputSlots);
        }
        return slot;
    }

    private boolean addOutputSlot(OutputSlot slot) {
        boolean res;
        if (this.outputSlots != null) {
            this.outputSlots.add(slot);
            res = true;
        } else if (this.singleOutput == null) {
            this.singleOutput = slot;
            slot.setPosition(0);
            res = false;
        } else {
            this.outputSlots = new ArrayList(2);
            this.outputSlots.add(this.singleOutput);
            this.outputSlots.add(slot);
            this.singleOutput = null;
            res = true;
        }
        if (res) {
            this.sourcesChanged(slot.getSource());
        }
        return res;
    }

    private void assignPositions(List<? extends Slot> slots) {
        for (int index = slots.size() - 1; index >= 0; --index) {
            slots.get(index).setPosition(index);
        }
    }

    public OutputSlot createOutputSlot(int index) {
        OutputSlot slot = new OutputSlot(this, index);
        if (this.addOutputSlot(slot)) {
            Collections.sort(this.outputSlots, Slot.slotIndexComparator);
            this.assignPositions(this.outputSlots);
        }
        return slot;
    }

    public List<InputSlot> getInputSlots() {
        return Collections.unmodifiableList(this.inputSlots);
    }

    int getInputSlotsWidth() {
        return Figure.getSlotsWidth(this.inputSlots);
    }

    public Set<Slot> getSlots() {
        HashSet<Slot> result = new HashSet<Slot>();
        result.addAll(this.getInputSlots());
        result.addAll(this.getOutputSlots());
        return result;
    }

    public List<OutputSlot> getOutputSlots() {
        if (this.outputSlots != null) {
            return Collections.unmodifiableList(this.outputSlots);
        }
        if (this.singleOutput != null) {
            return Collections.singletonList(this.singleOutput);
        }
        return Collections.emptyList();
    }

    public int getOutputSlotsWidth() {
        if (this.outputSlots != null) {
            return Figure.getSlotsWidth(this.outputSlots);
        }
        if (this.singleOutput != null) {
            return Figure.getSlotsWidth(Collections.singletonList(this.singleOutput));
        }
        return 0;
    }

    void removeInputSlot(InputSlot s, HashSet<Object> cleaned) {
        s.removeAllConnections(cleaned);
        this.inputSlots.remove(s);
    }

    void removeOutputSlot(OutputSlot s, HashSet<Object> cleaned) {
        s.removeAllConnections(cleaned);
        this.doRemoveOutputSlot(s);
    }

    public String[] getLines() {
        if (this.lines == null) {
            this.updateLines();
        }
        return this.lines;
    }

    public void updateLines() {
        String[] strings = this.diagram.getNodeText().split("\n");
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = Figure.resolveString(strings[i], this.getProperties());
        }
        this.lines = result;
    }

    public static final String resolveString(String string, Properties properties) {
        StringBuilder sb = new StringBuilder();
        boolean inBrackets = false;
        StringBuilder curIdent = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (inBrackets) {
                if (c == ']') {
                    Object value = properties.get(curIdent.toString());
                    if (value == null) {
                        value = "";
                    }
                    sb.append(value);
                    inBrackets = false;
                    continue;
                }
                curIdent.append(c);
                continue;
            }
            if (c == '[') {
                inBrackets = true;
                curIdent = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private int outputSlotCount() {
        return this.outputSlots == null ? (this.singleOutput != null ? 1 : 0) : this.outputSlots.size();
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public String toString() {
        return this.idString;
    }

    public Cluster getCluster() {
        if (this.getSource().getSourceNodes().isEmpty()) {
            assert (false) : "Should never reach here, every figure must have at least one source node!";
            return null;
        }
        InputBlock inputBlock = this.diagram.getGraph().getBlock(this.getSource().first());
        assert (inputBlock != null);
        Block result = this.diagram.getBlock(inputBlock);
        assert (result != null);
        return result;
    }

    public boolean isRoot() {
        if (this.isRoot == null) {
            List sourceNodes = this.source.getSourceNodes();
            this.isRoot = !sourceNodes.isEmpty() && "Root".equals(((InputNode)sourceNodes.get(0)).getProperties().get("name", String.class));
        }
        return this.isRoot;
    }

    public int compareTo(Vertex f) {
        return this.toString().compareTo(f.toString());
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getPosition(), this.getSize());
    }

    void sourcesChanged(Source s) {
        this.diagram.invalidateSlotMap();
        this.isRoot = null;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setBounds(Rectangle bounds) {
    }

    public boolean isBoundary() {
        return this.boundary;
    }

    public void setBoundary(boolean boundary) {
        this.boundary = boundary;
    }

    public Figure makeCopy(Diagram d) {
        Figure cf = new Figure(d, this.id);
        Figure.replaceFromTo(this, cf);
        return cf;
    }

    private static void replaceFromTo(Figure from, Figure to) {
        assert (from != to);
        assert (from != null && to != null);
        assert (from.id == to.id);
        to.source.replaceFrom(from.source);
        to.getProperties().clear();
        to.getProperties().add(from.getProperties());
        to.subgraphs = from.subgraphs;
        to.color = from.color;
        to.visible = from.visible;
        to.position = from.position.getLocation();
        to.boundary = from.boundary;
        to.heightCache = from.heightCache;
        to.widthCache = from.widthCache;
        to.lines = from.lines;
        to.inputSlots.clear();
        to.outputSlots = null;
        to.singleOutput = null;
        if (from.outputSlots != null) {
            for (Slot slot : from.outputSlots) {
                slot.copySlot(to);
            }
        } else if (from.singleOutput != null) {
            from.singleOutput.copySlot(to);
        }
        for (Slot slot : from.inputSlots) {
            slot.copySlot(to);
        }
    }

    public void replaceFrom(Figure source) {
        Figure.replaceFromTo(source, this);
    }
}

