/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graph;

import java.awt.Point;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.Slot;

public class InputSlot
extends Slot {
    protected InputSlot(Figure figure, int wantedIndex) {
        super(figure, wantedIndex);
    }

    @Override
    protected Slot copyInto(Figure f) {
        int index = this.getWantedIndex();
        if (index == -1) {
            return f.createInputSlot();
        }
        return f.createInputSlot(index);
    }

    public Point getRelativePosition() {
        int gap = this.getFigure().getWidth() - this.getFigure().getInputSlotsWidth();
        if (gap < 0) {
            gap = 0;
        }
        double gapRatio = (double)gap / (double)(this.getFigure().getInputSlots().size() + 1);
        int gapAmount = (int)((double)(this.getPosition() + 1) * gapRatio);
        return new Point(gapAmount + this.getFigure().getSlotsWidthBefore(this) + this.getWidth() / 2, -4);
    }

    public String toString() {
        return "InputSlot[figure=" + this.getFigure().toString() + ", position=" + this.getPosition() + "]";
    }
}

