/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.script.impl;

import java.io.Closeable;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.graalvm.visualizer.script.CancelExceptionMixin;
import org.graalvm.visualizer.script.PreparedScript;
import org.graalvm.visualizer.script.ScriptCancelledException;
import org.graalvm.visualizer.script.ScriptDefinition;
import org.graalvm.visualizer.script.ScriptEnvironment;
import org.graalvm.visualizer.script.UserScriptEngine;
import org.graalvm.visualizer.script.impl.Bundle;
import org.graalvm.visualizer.script.spi.UserScriptProcessor;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.scripting.Scripting;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class GraalSDKEngine
implements UserScriptEngine {
    private static final Logger LOG = Logger.getLogger(GraalSDKEngine.class.getName());
    private static final String MIME_JAVASCRIPT = "text/javascript";
    private static final String MIME_FASTR = "text/x-r";
    private static final String MIME_RUBY = "text/x-ruby";
    private static final String MIME_PYTHON = "text/x-python";
    private static final String ID_JAVASCRIPT = "js";
    private static final String ID_FASTR = "fastr";
    private static final String ID_RUBY = "ruby";
    private static final String ID_PYTHON = "python";
    private static final Map<String, String> GRAAL_MIME_MAP = new HashMap<String, String>();
    private static final Map<String, String> GRAAL_MIME_MAP_REVERSE = new HashMap<String, String>();
    private final Set<String> supportedLanguages;
    private static final AtomicInteger uniq;
    private static final Writer defaultOutWriter;
    private static final Writer defaultErrWriter;

    public GraalSDKEngine() {
        HashSet<String> mimeSet = new HashSet<String>();
        this.supportedLanguages = Collections.unmodifiableSet(mimeSet);
        ScriptEngine graalEngine = Scripting.createManager().getEngineByName("GraalVM:js");
        if (graalEngine != null) {
            ScriptEngineFactory factory = graalEngine.getFactory();
            String langId = factory.getEngineName();
            mimeSet.addAll(factory.getMimeTypes());
            String mime = GRAAL_MIME_MAP.get(langId);
            if (mime != null) {
                mimeSet.add(mime);
            }
        }
    }

    private String toPolyglotSource(String mime, String script, String filename) throws ScriptException {
        String graalID = GRAAL_MIME_MAP_REVERSE.get(mime);
        if (graalID == null) {
            graalID = mime;
        }
        return script;
    }

    @Override
    public boolean acceptsLanguage(String mime) {
        return this.supportedLanguages().contains(mime);
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public Set<String> supportedLanguages() {
        return this.supportedLanguages;
    }

    private Map<String, Object> exportJavaTypes(Map<String, Object> bindings, ScriptDefinition def) throws ScriptException {
        FileObject scriptFolder = FileUtil.getConfigFile((String)("ScriptingEnvironment/" + def.getMimeType()));
        if (scriptFolder == null) {
            return Collections.emptyMap();
        }
        for (FileObject sf : FileUtil.getOrder(Arrays.asList(scriptFolder.getChildren()), (boolean)false)) {
            if (!"classes".equals(sf.getExt())) continue;
            Properties props = new Properties();
            try (InputStream is = sf.getInputStream();){
                props.load(is);
            }
            catch (IOException ex) {
                ScriptException scriptEx = new ScriptException(Bundle.ERR_LoadingGlobalTypes(sf.getNameExt(), ex.toString()));
                scriptEx.initCause(ex);
                this.printException(def, scriptEx);
            }
            for (String global : props.stringPropertyNames()) {
                String className = props.getProperty(global).trim();
                if ("".equals(className)) {
                    bindings.remove(global);
                    continue;
                }
                if (bindings.containsKey(global)) continue;
                try {
                    Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    bindings.put(global, clazz);
                }
                catch (ClassNotFoundException ex) {
                    ScriptException scriptEx = new ScriptException(Bundle.ERR_CreatingGlobaType(sf.getNameExt(), ex.toString(), className));
                    scriptEx.initCause(ex);
                    this.printException(def, scriptEx);
                }
            }
        }
        return bindings;
    }

    private void printException(ScriptDefinition def, Throwable ex) {
        if (def.getOutput() == null) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO));
        } else {
            PrintWriter pw = def.getOutput();
            pw.println(ex.toString());
            ex.printStackTrace(pw);
        }
    }

    @Override
    public PreparedScript prepare(ScriptEnvironment env, ScriptDefinition def) throws ScriptException {
        String src;
        ContextHolder h = this.prepareContext(env);
        ScriptEngine ctx = h.get();
        ArrayList<String> globals = new ArrayList<String>();
        String transformed = def.getCode();
        Collection processors = MimeLookup.getLookup((String)def.getMimeType()).lookupAll(UserScriptProcessor.class);
        ScriptDefinition customDef = def;
        if (!h.initialized) {
            h.initialized = true;
            Map<String, Object> types = this.exportJavaTypes(new HashMap<String, Object>(), def);
            if (!types.isEmpty()) {
                customDef = def.copy();
                for (String s : types.keySet()) {
                    customDef.global(s, types.get(s));
                }
            }
        }
        for (UserScriptProcessor proc : processors) {
            String globs;
            String s;
            if (!def.getGlobals().isEmpty() && (globs = proc.assignGlobals(customDef)) != null) {
                globals.add(this.toPolyglotSource(def.getMimeType(), globs, "<globals>"));
            }
            if ((s = proc.processUserCode(customDef, transformed)) == null) continue;
            transformed = s;
        }
        for (String b : def.getGlobals().keySet()) {
            ctx.getBindings(200).put(b, def.getGlobals().get(b));
        }
        try {
            src = this.toPolyglotSource(def.getMimeType(), transformed, def.getScriptFilename());
        }
        catch (RuntimeException ex) {
            Logger.getLogger(GraalSDKEngine.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        return new PolyglotExecutable(env, def, customDef, transformed, src, globals);
    }

    private ContextHolder prepareContext(ScriptEnvironment env) {
        ContextHolder ctx = (ContextHolder)env.getValue(this);
        if (ctx != null) {
            return ctx;
        }
        ScriptEngine engine = Scripting.createManager().getEngineByName("GraalVM:js");
        ctx = new ContextHolder(engine);
        env.setValue(this, ctx);
        return ctx;
    }

    private void clearContext(ScriptEnvironment env) {
        env.setValue(this, null);
    }

    static {
        GRAAL_MIME_MAP.put(ID_JAVASCRIPT, MIME_JAVASCRIPT);
        GRAAL_MIME_MAP.put(ID_FASTR, MIME_FASTR);
        GRAAL_MIME_MAP.put(ID_RUBY, MIME_RUBY);
        GRAAL_MIME_MAP.put(ID_PYTHON, MIME_PYTHON);
        for (Map.Entry<String, String> e : GRAAL_MIME_MAP.entrySet()) {
            GRAAL_MIME_MAP_REVERSE.put(e.getValue(), e.getKey());
        }
        uniq = new AtomicInteger(0);
        defaultOutWriter = new OutputStreamWriter(System.out);
        defaultErrWriter = new OutputStreamWriter(System.err);
    }

    private static class ContextHolder
    implements Closeable {
        private final ScriptEngine ctx;
        private final DelegatingWriter outStream = new DelegatingWriter(defaultOutWriter);
        private final DelegatingWriter errStream = new DelegatingWriter(defaultErrWriter);
        private boolean initialized;
        private Map<String, Object> types = new HashMap<String, Object>();

        public ContextHolder(ScriptEngine builder) {
            this.ctx = builder;
            builder.getContext().setWriter(this.outStream);
            builder.getContext().setErrorWriter(this.errStream);
        }

        @Override
        public void close() throws IOException {
            this.outStream.flush();
            this.errStream.flush();
            if (this.ctx instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.ctx)).close();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public ScriptEngine get() {
            return this.ctx;
        }
    }

    private final class PolyglotExecutable
    implements PreparedScript {
        private final ScriptEnvironment env;
        private final ScriptDefinition def;
        private final ScriptDefinition origDef;
        private final String source;
        private final List<String> globals;
        private final String wrappedCode;
        private final Object lock = new Object();
        private final Object engineLock = new Object();
        private Object pendingToken;
        private Thread executionThread;
        private boolean canceled;
        private ScriptEngine polyContext;

        public PolyglotExecutable(ScriptEnvironment env, ScriptDefinition def, ScriptDefinition customDef, String wrappedCode, String source, List<String> globals) {
            this.origDef = def;
            this.def = customDef;
            this.env = env;
            this.wrappedCode = wrappedCode;
            this.source = source;
            this.globals = globals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object doEvaluate2(Map<String, Object> allValues) throws ScriptException {
            Object srcValue;
            this.clear();
            ContextHolder h = GraalSDKEngine.this.prepareContext(this.env);
            ScriptEngine ctx = h.get();
            DelegatingWriter saveErrWriter = h.errStream;
            DelegatingWriter saveOutWriter = h.outStream;
            Object object = this.lock;
            synchronized (object) {
                this.polyContext = ctx;
            }
            try {
                int i;
                Object[] args;
                if (this.def.getOutput() != null) {
                    h.outStream.setWriter(this.def.getOutput());
                }
                if (this.def.getError() != null) {
                    h.outStream.setWriter(this.def.getError());
                }
                if (this.globals != null && !this.globals.isEmpty()) {
                    Map<String, Object> bindings = this.def.getGlobals();
                    args = new Object[bindings.size()];
                    i = 0;
                    for (String n : bindings.keySet()) {
                        args[i++] = bindings.get(n);
                    }
                    for (String s : this.globals) {
                        Object gFunction = ctx.eval(s);
                        Invoke invoke = ((Invocable)((Object)ctx)).getInterface(gFunction, Invoke.class);
                        if (invoke == null) continue;
                        invoke.execute(args);
                    }
                }
                srcValue = ctx.eval(this.source);
                Invoke srcValueInv = ((Invocable)((Object)ctx)).getInterface(srcValue, Invoke.class);
                if (!this.def.getParamNames().isEmpty() && srcValueInv != null) {
                    args = new Object[this.def.getParamNames().size()];
                    i = 0;
                    for (String n : this.def.getParamNames()) {
                        args[i++] = allValues.get(n);
                    }
                    Object object2 = srcValueInv.execute(args);
                    return object2;
                }
            }
            catch (Error | RuntimeException ex) {
                this.checkCancelled(ex);
                throw ex;
            }
            catch (ScriptException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.polyContext = null;
                }
                if (this.def.getOutput() != null) {
                    h.outStream.setWriter(saveOutWriter);
                }
                if (this.def.getError() != null) {
                    h.outStream.setWriter(saveErrWriter);
                }
            }
            return srcValue;
        }

        private void checkCancelled(Throwable ex) throws ScriptException {
            for (Throwable item = ex; item != null; item = item.getCause()) {
                if (!(item instanceof CancelExceptionMixin)) continue;
                throw new ScriptCancelledException(this.env);
            }
        }

        @Override
        public String getOriginalCode() {
            return this.origDef.getCode();
        }

        @Override
        public String getExecutableCode() {
            return this.wrappedCode;
        }

        @Override
        public Iterable<String> parameterNames() {
            return this.origDef.getParamNames();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object evaluate(Map<String, Object> argValues) throws ScriptException {
            Object object = this.engineLock;
            synchronized (object) {
                return this.doEvaluate(argValues);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object doEvaluate(Map<String, Object> argValues) throws ScriptException {
            HashMap<String, Object> allValues = new HashMap<String, Object>(this.def.getParameters());
            allValues.putAll(argValues);
            ScriptEnvironment token = this.env;
            long t = System.currentTimeMillis();
            ScriptException annotateCancel = null;
            String name = this.def.getScriptFilename();
            boolean softCancelled = false;
            try {
                Object v;
                Object object = this.lock;
                synchronized (object) {
                    this.pendingToken = token;
                    if (this.canceled) {
                        this.clear();
                    }
                    this.canceled = false;
                    this.executionThread = Thread.currentThread();
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Executing script: {0}, token: {1}", new Object[]{name, Integer.toHexString(System.identityHashCode(token))});
                }
                Object object2 = v = this.doEvaluate2(allValues);
                return object2;
            }
            catch (ScriptException ex) {
                ScriptException hostT = ex;
                if (hostT instanceof CancelExceptionMixin) {
                    softCancelled = true;
                }
                Object object = this.lock;
                synchronized (object) {
                    if (!softCancelled && !this.canceled) {
                        throw new ScriptException(ex);
                    }
                    annotateCancel = ex;
                }
                LOG.log(Level.FINER, "Execution of " + name + " failed with exception", ex);
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    assert (this.pendingToken == token);
                    this.executionThread = null;
                    this.pendingToken = null;
                    boolean c = this.canceled;
                    this.canceled = false;
                    if (c) {
                        this.clear();
                    }
                    if (c || softCancelled) {
                        this.clear();
                        if (annotateCancel != null) {
                            LOG.log(Level.FINER, "Execution of {0} was cancelled", name);
                            ScriptCancelledException xx = annotateCancel instanceof ScriptCancelledException ? (ScriptCancelledException)annotateCancel : new ScriptCancelledException(token, annotateCancel);
                            throw xx;
                        }
                        LOG.log(Level.FINER, "Execution of {0} was cancelled without PolyglotException", name);
                        throw new ScriptCancelledException(token);
                    }
                }
            }
            assert (false);
            return null;
        }

        private void clear() {
            this.polyContext = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            ScriptEngine c;
            Object object = this.lock;
            synchronized (object) {
                this.canceled = true;
                if (this.executionThread == null) {
                    return false;
                }
                assert (this.executionThread != Thread.currentThread());
                if (this.pendingToken != this.env || this.polyContext == null) {
                    return false;
                }
                c = this.polyContext;
                this.executionThread.interrupt();
            }
            try {
                if (c instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)c)).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        @Override
        public UserScriptEngine getEngine() {
            return GraalSDKEngine.this;
        }

        @Override
        public ScriptEnvironment getEnvironment() {
            return this.env;
        }
    }

    @FunctionalInterface
    public static interface Invoke {
        public Object execute(Object ... var1);
    }

    private static final class DelegatingWriter
    extends FilterWriter {
        DelegatingWriter(Writer out) {
            super(out);
        }

        void setWriter(Writer w) {
            this.out = w;
        }
    }
}

