/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.Assert;

public class TestUtils {
    private TestUtils() {
    }

    public static boolean checkNotNulls(Object a, Object b) {
        if (a == null || b == null) {
            Assert.assertEquals(a, b);
            return false;
        }
        return true;
    }

    public static <T> void assertNot(T a, T b, BiConsumer<T, T> assertion) {
        TestUtils.assertNot(a, b, assertion, "");
    }

    public static <T> void assertNot(T a, T b, BiConsumer<T, T> assertion, String failMessage) {
        try {
            assertion.accept(a, b);
        }
        catch (AssertionError e) {
            return;
        }
        Assert.fail(failMessage);
    }

    public static <T> void assertCollections_NoOrder(Collection<? extends T> a, Collection<? extends T> b, BiConsumer<T, T> assertion) {
        TestUtils.assertCollections_NoOrder(a, b, assertion, Objects::hashCode);
    }

    public static <T, M> void assertCollections_NoOrder(Collection<? extends T> a, Collection<? extends T> b, BiConsumer<T, T> assertion, Function<T, M> mapFunc) {
        if (TestUtils.checkNotNulls(a, b)) {
            Assert.assertEquals(a.size(), b.size());
            HashMap objs = new HashMap();
            b.forEach(obj -> objs.put(mapFunc.apply(obj), obj));
            a.forEach(obj -> assertion.accept(obj, objs.get(mapFunc.apply(obj))));
        }
    }

    public static <T> void assertCollections_InOrder(Collection<? extends T> a, Collection<? extends T> b, BiConsumer<T, T> assertion) {
        if (TestUtils.checkNotNulls(a, b)) {
            Assert.assertEquals(a.size(), b.size());
            ArrayList objs = new ArrayList();
            b.forEach(objs::add);
            int i = 0;
            for (T obj : a) {
                assertion.accept(obj, objs.get(i++));
            }
        }
    }

    public static <T> void assertSetEquals(Set<? extends T> a, Set<? extends T> b) {
        if (TestUtils.checkNotNulls(a, b)) {
            Assert.assertEquals(a.size(), b.size());
            b.forEach(obj -> Assert.assertTrue(a.contains(obj)));
        }
    }

    public static <T> void assertListEquals(List<? extends T> a, List<? extends T> b, BiConsumer<T, T> assertion) {
        if (TestUtils.checkNotNulls(a, b)) {
            Assert.assertEquals(a.size(), b.size());
            for (int i = 0; i < a.size(); ++i) {
                assertion.accept(a.get(i), b.get(i));
            }
        }
    }
}

