/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.settings.graal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.visualizer.settings.SettingsStore;
import org.openide.util.NbBundle;

public final class GraalSettings
extends SettingsStore<GraalSettings, GraalSettingBean> {
    public static final String PORT_BINARY = "portBinary";
    public static final int PORT_BINARY_DEFAULT = 4445;
    public static final String DIRECTORY = "directory";
    public static final String DIRECTORY_DEFAULT = System.getProperty("user.dir");
    public static final String MAP = "map";
    public static final String MAP_DEFAULT = "";
    public static final String REPOSITORY = "repository";
    public static final String REPOSITORY_DEFAULT = NbBundle.getMessage(GraalSettings.class, (String)"DefaultMavenRepository");
    public static final String CLEAN_CACHES = "cleanCaches";
    public static final String ACCEPT_NETWORK = "acceptNetwork";
    public static final boolean ACCEPT_NETWORK_DEFAULT = false;
    public static final String SESSION_CLOSE_TIMEOUT = "sessionCloseTimeout";
    public static final int SESSION_CLOSE_TIMEOUT_DEFAULT = 10;
    public static final String AUTO_SEPARATE_SESSIONS = "autoSeparateSessions";
    public static final boolean AUTO_SEPARATE_SESSIONS_DEFAULT = false;

    public static GraalSettings obtain() {
        return SettingsStore.obtain(GraalSettings.class, GraalSettings::new);
    }

    private GraalSettings() {
    }

    @Override
    protected void fillDefaults(BiConsumer<String, Object> filler) {
        filler.accept(PORT_BINARY, 4445);
        filler.accept(REPOSITORY, REPOSITORY_DEFAULT);
        filler.accept(CLEAN_CACHES, true);
        filler.accept(ACCEPT_NETWORK, false);
        filler.accept(SESSION_CLOSE_TIMEOUT, 10);
        filler.accept(AUTO_SEPARATE_SESSIONS, false);
        filler.accept(MAP, MAP_DEFAULT);
        filler.accept(DIRECTORY, DIRECTORY_DEFAULT);
    }

    public String getDirectory() {
        return this.get(String.class, DIRECTORY);
    }

    public void setDirectory(String dir) {
        this.set(DIRECTORY, dir != null && !dir.isEmpty() ? dir : DIRECTORY_DEFAULT);
    }

    public List<String> getFileMap() {
        String s = this.get(String.class, MAP);
        if (s.isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(s.split(Pattern.quote(File.pathSeparator))).collect(Collectors.toList());
    }

    public void setFileMap(List<String> items) {
        if (items == null || items.isEmpty()) {
            this.set(MAP, MAP_DEFAULT);
        } else {
            this.set(MAP, items.stream().collect(Collectors.joining(File.pathSeparator)));
        }
    }

    public void addFilesToMap(List<String> fileNames) {
        List<String> files = this.getFileMap();
        files.addAll(fileNames);
        this.setFileMap(files);
    }

    public void removeFilesFromMap(List<String> fileNames) {
        List<String> files = this.getFileMap();
        files.removeAll(fileNames);
        this.setFileMap(files);
    }

    @Override
    protected GraalSettingBean makeBean() {
        return new GraalSettingBean(this);
    }

    public static final class GraalSettingBean
    extends SettingsStore.SettingsBean<GraalSettings, GraalSettingBean> {
        GraalSettingBean(GraalSettings store) {
            super(store);
        }

        GraalSettingBean(GraalSettingBean bean) {
            super(bean);
        }

        @Override
        public GraalSettingBean copy() {
            return new GraalSettingBean(this);
        }
    }
}

