/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.profiles.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.impl.ProfileAccessor;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileStorage;
import org.graalvm.visualizer.filter.profiles.mgmt.SimpleProfileSelector;
import org.graalvm.visualizer.filter.profiles.spi.ProfileGraphMatcher;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class BuiltinGraphMatcher
implements ProfileGraphMatcher {
    public static final String SELECTOR_EXTENSION = "selector";
    public static final String SELECTOR_ORDER = "selector.order";
    public static final String ATTR_MATCH_GRAPH_PREFIX = "matchGraph.";
    public static final String ATTR_MATCH_NODE_PREFIX = "matchNode.";
    public static final String ATTR_MATCH_GROUP_PREFIX = "matchGroupProperty.";
    public static final String ATTR_MATCH_GRAPH_PROPERTY_PREFIX = "matchGraphProperty.";
    public static final String ATTR_CUSTOM_MATCHER = "profileGraphMatcher";
    private static final String ATTR_ORDER = "order";
    public static final String GRAPH_TYPE = "type";
    public static final String GRAPH_NAME = "name";
    public static final String GRAPH_NODE_COUNT = "nodeCount";
    private static final String FORMAT_FLOAT = "float";
    private static final String FORMAT_NUMBER = "number";
    private static final String FORMAT_CONTAINS = "contains";
    private static final String FORMAT_REGEXP = "regexp";
    private static final String FORMAT_SAME = "same";
    private static final String DEFAULT_SELECTOR_EXT = "selector";
    private static final String DEFAULT_SELECTOR_NAME = "simple";
    private final ProfileStorage profiles;
    private final Map<String, List<ProfileMatch>> acceptors = new HashMap<String, List<ProfileMatch>>();
    private FileChangeListener fl = new FL();

    public BuiltinGraphMatcher() {
        this.profiles = (ProfileStorage)Lookup.getDefault().lookup(ProfileStorage.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMatches(FileObject f) {
        BuiltinGraphMatcher builtinGraphMatcher = this;
        synchronized (builtinGraphMatcher) {
            this.acceptors.put(f.getPath(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int matchesInputGraph(FilterProfile profile, InputGraph gr, GraphContainer parent, Lookup context) {
        List<ProfileMatch> matches;
        FileObject folder = this.profiles.getProfileFolder(profile);
        if (folder == null) {
            return -1;
        }
        BuiltinGraphMatcher builtinGraphMatcher = this;
        synchronized (builtinGraphMatcher) {
            matches = this.acceptors.get(folder.getPath());
            if (matches == null) {
                if (!this.acceptors.containsKey(folder.getPath())) {
                    folder.addFileChangeListener(this.fl);
                }
                matches = this.buildProfileMatchers(folder);
                this.acceptors.put(folder.getPath(), matches);
            }
        }
        int max = -1;
        for (ProfileMatch m : matches) {
            max = Math.max(max, m.match(gr, parent, profile, context));
        }
        return max;
    }

    private List<ProfileMatch> buildProfileMatchers(FileObject profileFolder) {
        ArrayList<ProfileMatch> result = new ArrayList<ProfileMatch>();
        int defaultOrder = 0;
        for (FileObject fo : profileFolder.getChildren()) {
            if (!"selector".equals(fo.getExt())) continue;
            Object o = fo.getAttribute(ATTR_CUSTOM_MATCHER);
            ProfileGraphMatcher customMatcher = null;
            if (o instanceof ProfileGraphMatcher) {
                customMatcher = (ProfileGraphMatcher)o;
            }
            Properties props = new Properties();
            try (InputStream fos = fo.getInputStream();
                 InputStreamReader isr = new InputStreamReader(fos, "ISO-8859-1");){
                props.load(isr);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            int order = defaultOrder;
            if (props.getProperty(SELECTOR_ORDER) != null) {
                try {
                    order = Integer.parseInt(props.getProperty(SELECTOR_ORDER));
                }
                catch (NumberFormatException isr) {}
            } else {
                o = fo.getAttribute(ATTR_ORDER);
                if (o instanceof Integer) {
                    order = (Integer)o;
                }
            }
            ProfileMatch m = new ProfileMatchBuilder(props, customMatcher).build();
            m.order = order;
            result.add(m);
        }
        return result;
    }

    public static void saveSelectorImpl(SimpleProfileSelector selector) throws IOException {
        final FileObject f = ProfileAccessor.getInstance().getSelectorFile(selector);
        if (!selector.isValid()) {
            throw new IOException("Invalid selector");
        }
        ProfileAccessor gate = ProfileAccessor.getInstance();
        final Properties props = new Properties();
        BuiltinGraphMatcher.storeSelector(selector, props);
        f.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                block9: {
                    FileObject toDelete = null;
                    if (f.isFolder()) {
                        String n = FileUtil.findFreeFileName((FileObject)f, (String)BuiltinGraphMatcher.DEFAULT_SELECTOR_NAME, (String)"selector");
                        toDelete = f.createData(n);
                    }
                    try (OutputStream outStream = f.getOutputStream();){
                        props.store(outStream, null);
                    }
                    catch (IOException ex) {
                        if (toDelete == null) break block9;
                        toDelete.delete();
                    }
                }
            }
        });
    }

    public static SimpleProfileSelector simpleSelectorImpl(FilterProfile p) {
        FileObject folder;
        ProfileStorage storage;
        ProfileService profS = (ProfileService)Lookup.getDefault().lookup(ProfileService.class);
        if (profS == null) {
            return null;
        }
        if (!(profS instanceof ProfileStorage)) {
            storage = (ProfileStorage)profS.getLookup().lookup(ProfileStorage.class);
            if (storage == null) {
                return null;
            }
        } else {
            storage = (ProfileStorage)((Object)profS);
        }
        if ((folder = storage.getProfileFolder(p)) == null || folder == storage.getProfileFolder(profS.getDefaultProfile())) {
            return null;
        }
        FileObject selectorFile = null;
        for (FileObject fo : folder.getChildren()) {
            if (!"selector".equals(fo.getExt())) continue;
            if (selectorFile != null) {
                return null;
            }
            selectorFile = fo;
        }
        SimpleProfileSelector.init();
        ProfileAccessor gate = ProfileAccessor.getInstance();
        FileObject selFile = selectorFile != null ? selectorFile : folder;
        SimpleProfileSelector sel = gate.createSimpleSelector(selFile);
        if (selectorFile == null) {
            gate.setSelectorValid(sel, true);
            return sel;
        }
        try (InputStream inStream = selectorFile.getInputStream();){
            Properties data = new Properties();
            data.load(inStream);
            BuiltinGraphMatcher.loadSelector(sel, data);
            Object o = selectorFile.getAttribute(ATTR_ORDER);
            if (o instanceof Integer) {
                sel.setOrder((Integer)o);
            }
            gate.setSelectorValid(sel, true);
        }
        catch (IOException | IllegalStateException ex) {
            gate.setSelectorValid(sel, false);
        }
        return sel;
    }

    private static void filterRegexpProperties(Properties props, String prefix, C callback) {
        HashSet processed = new HashSet();
        props.stringPropertyNames().stream().filter(s -> s.startsWith(prefix)).forEach(s -> {
            String rest = s.substring(prefix.length());
            processed.add(s);
            int i = rest.indexOf(44);
            boolean regexp = true;
            if (i != -1) {
                String format = rest.substring(i + 1);
                rest = rest.substring(0, i);
                if (FORMAT_REGEXP.equals(format)) {
                    regexp = true;
                } else if (FORMAT_SAME.equals(format)) {
                    regexp = false;
                } else {
                    throw new IllegalStateException();
                }
            }
            callback.accept(rest, props.getProperty((String)s), regexp);
        });
        props.keySet().removeAll(processed);
    }

    private static void loadSelector(SimpleProfileSelector sele, Properties props) throws IllegalStateException {
        sele.setGraphNameRegexp(true);
        sele.setOwnerNameRegexp(true);
        BuiltinGraphMatcher.filterRegexpProperties(props, ATTR_MATCH_GRAPH_PREFIX, (k, val, r) -> {
            switch (k) {
                case "type": {
                    sele.setGraphType(val);
                    break;
                }
                case "name": {
                    sele.setGraphName(val);
                    sele.setGraphNameRegexp(r);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        BuiltinGraphMatcher.filterRegexpProperties(props, ATTR_MATCH_GROUP_PREFIX, (k, val, r) -> {
            switch (k) {
                case "name": {
                    sele.setOwnerName(val);
                    sele.setOwnerNameRegexp(r);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        String orderText = props.getProperty(SELECTOR_ORDER);
        if (orderText != null) {
            try {
                Integer o = Integer.parseInt(orderText);
                sele.setOrder(o);
            }
            catch (NumberFormatException ex) {
                throw new IllegalStateException(ex);
            }
        }
        props.remove(SELECTOR_ORDER);
        if (!props.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    private static void storeSelector(SimpleProfileSelector sele, Properties props) {
        Object n;
        String v;
        int o = sele.getOrder();
        if (o > 0) {
            props.setProperty(SELECTOR_ORDER, Integer.toString(o));
        }
        if ((v = sele.getGraphName()) != null && !v.trim().isEmpty()) {
            n = "matchGraph.name";
            if (!sele.isGraphNameRegexp()) {
                n = (String)n + ",same";
            }
            props.setProperty((String)n, v.trim());
        }
        if ((v = sele.getGraphType()) != null && !v.trim().isEmpty()) {
            n = "matchGraph.type";
            props.setProperty((String)n, v.trim());
        }
        if ((v = sele.getOwnerName()) != null && !v.trim().isEmpty()) {
            n = "matchGroupProperty.name";
            if (!sele.isOwnerNameRegexp()) {
                n = (String)n + ",same";
            }
            props.setProperty((String)n, v.trim());
        }
    }

    private class FL
    extends FileChangeAdapter {
        private FL() {
        }

        public void fileDeleted(FileEvent fe) {
            FileObject f = fe.getFile();
            if (f.isFolder()) {
                fe.getFile().removeFileChangeListener((FileChangeListener)this);
            } else {
                BuiltinGraphMatcher.this.clearMatches(fe.getFile().getParent());
                fe.getFile().removeFileChangeListener((FileChangeListener)this);
            }
        }

        public void fileChanged(FileEvent fe) {
            BuiltinGraphMatcher.this.clearMatches(fe.getFile().getParent());
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject f = fe.getFile();
            if ("selector".equals(f.getExt())) {
                BuiltinGraphMatcher.this.clearMatches(fe.getFile());
                fe.getFile().addFileChangeListener((FileChangeListener)this);
            }
        }
    }

    private static class ProfileMatch {
        final Map<String, Properties.PropertyMatcher> graphMatches = new HashMap<String, Properties.PropertyMatcher>();
        final Map<String, Properties.PropertyMatcher> nodeMatches = new HashMap<String, Properties.PropertyMatcher>();
        final Map<String, Properties.PropertyMatcher> graphPropertyMatches = new HashMap<String, Properties.PropertyMatcher>();
        final Map<String, Properties.PropertyMatcher> groupPropertyMatches = new HashMap<String, Properties.PropertyMatcher>();
        final ProfileGraphMatcher customMatcher;
        private boolean dead;
        private int order;

        public ProfileMatch(ProfileGraphMatcher m) {
            this.customMatcher = m;
        }

        boolean matchProperty(jdk.graal.compiler.graphio.parsing.model.Properties p, Map<String, Properties.PropertyMatcher> map) {
            for (Map.Entry<String, Properties.PropertyMatcher> me : map.entrySet()) {
                String pn = me.getKey();
                String val = (String)p.get(pn, String.class);
                if (!me.getValue().match((Object)val)) continue;
                return true;
            }
            return map.isEmpty();
        }

        boolean matchNodeProperty(InputGraph data, Map<String, Properties.PropertyMatcher> map) {
            Properties.PropertySelector psel = new Properties.PropertySelector(data.getNodes());
            for (Map.Entry<String, Properties.PropertyMatcher> me : map.entrySet()) {
                String pn = me.getKey();
                Properties.PropertyMatcher m = map.get(pn);
                if (psel.selectSingle(m) != null) continue;
                return false;
            }
            return map.isEmpty();
        }

        private boolean matchGraphProperties(InputGraph data, GraphContainer parent) {
            boolean success = false;
            for (String s : this.graphMatches.keySet()) {
                Properties.PropertyMatcher matcher = this.graphMatches.get(s);
                if (!matcher.match(switch (s) {
                    case BuiltinGraphMatcher.GRAPH_TYPE -> data.getGraphType();
                    case BuiltinGraphMatcher.GRAPH_NAME -> data.getName();
                    case BuiltinGraphMatcher.GRAPH_NODE_COUNT -> data.getNodeCount();
                    default -> null;
                })) {
                    return false;
                }
                success = true;
            }
            return success || this.graphMatches.isEmpty();
        }

        int match(InputGraph data, GraphContainer parent, FilterProfile profile, Lookup context) {
            if (this.dead) {
                return -1;
            }
            if (!this.matchGraphProperties(data, parent)) {
                return -1;
            }
            if (!this.matchProperty(data.getProperties(), this.graphPropertyMatches)) {
                return -1;
            }
            Group g = parent.getContentOwner();
            if (g == null) {
                if (!this.groupPropertyMatches.isEmpty()) {
                    return -1;
                }
            } else if (!this.groupPropertyMatches.isEmpty()) {
                while (!this.matchProperty(g.getProperties(), this.groupPropertyMatches)) {
                    Folder f = g.getParent();
                    if (f instanceof Group) {
                        g = (Group)f;
                        continue;
                    }
                    return -1;
                }
            }
            if (!this.matchNodeProperty(data, this.nodeMatches)) {
                return -1;
            }
            if (this.customMatcher != null) {
                return this.customMatcher.matchesInputGraph(profile, data, parent, context);
            }
            return this.order;
        }
    }

    private static class ProfileMatchBuilder {
        private final Properties selectorProperties;
        private final ProfileMatch result;
        private boolean hasFilter;
        private static final Map<String, NumericMatcher.Op> OPER_SYMS = new HashMap<String, NumericMatcher.Op>();

        public ProfileMatchBuilder(Properties props, ProfileGraphMatcher customMatcher) {
            this.selectorProperties = props;
            this.result = new ProfileMatch(customMatcher);
        }

        public ProfileMatch build() {
            this.processMatchAttribute(BuiltinGraphMatcher.ATTR_MATCH_GRAPH_PREFIX, this.result.graphMatches::put);
            this.processMatchAttribute(BuiltinGraphMatcher.ATTR_MATCH_GROUP_PREFIX, this.result.groupPropertyMatches::put);
            this.processMatchAttribute(BuiltinGraphMatcher.ATTR_MATCH_GRAPH_PROPERTY_PREFIX, this.result.graphPropertyMatches::put);
            this.processMatchAttribute(BuiltinGraphMatcher.ATTR_MATCH_NODE_PREFIX, this.result.nodeMatches::put);
            if (!this.hasFilter) {
                this.result.dead = true;
            }
            return this.result;
        }

        private Properties.PropertyMatcher parseNumericComparison(String name, String rawVal, boolean fl) {
            ArrayList<String> m = new ArrayList<String>(OPER_SYMS.keySet());
            Collections.sort(m, Collections.reverseOrder());
            for (String s : m) {
                if (!rawVal.startsWith(s)) continue;
                String v = rawVal.substring(s.length()).trim();
                Double match = fl ? Double.parseDouble(v) : (double)Integer.parseInt(v);
                return new NumericMatcher(name, OPER_SYMS.get(s), match);
            }
            Double match = fl ? Double.parseDouble(rawVal) : (double)Integer.parseInt(rawVal);
            return new NumericMatcher(name, NumericMatcher.Op.EQ, match);
        }

        private void processMatchAttribute(String prefix, BiFunction<String, Properties.PropertyMatcher, Properties.PropertyMatcher> putFunction) {
            for (String aName : this.selectorProperties.stringPropertyNames()) {
                if (!aName.startsWith(prefix)) continue;
                String prop = aName.substring(prefix.length());
                int comma = prop.lastIndexOf(44);
                String format = BuiltinGraphMatcher.FORMAT_REGEXP;
                if (comma != -1) {
                    format = prop.substring(comma + 1, prop.length()).trim();
                    prop = prop.substring(0, comma);
                }
                String rawVal = this.selectorProperties.getProperty(aName);
                Object pm = switch (format) {
                    case BuiltinGraphMatcher.FORMAT_SAME -> new Properties.EqualityPropertyMatcher(prop, (Object)rawVal);
                    default -> new Properties.RegexpPropertyMatcher(prop, rawVal, false, 2);
                    case BuiltinGraphMatcher.FORMAT_CONTAINS -> new SubstringPropertyMatcher(prop, rawVal);
                    case BuiltinGraphMatcher.FORMAT_NUMBER -> this.parseNumericComparison(prop, rawVal, false);
                    case BuiltinGraphMatcher.FORMAT_FLOAT -> this.parseNumericComparison(prop, rawVal, true);
                };
                this.hasFilter = true;
                putFunction.apply(prop, (Properties.PropertyMatcher)pm);
            }
        }

        static {
            OPER_SYMS.put(">", NumericMatcher.Op.GT);
            OPER_SYMS.put(">=", NumericMatcher.Op.GE);
            OPER_SYMS.put("<", NumericMatcher.Op.LT);
            OPER_SYMS.put("<=", NumericMatcher.Op.LE);
            OPER_SYMS.put("=", NumericMatcher.Op.EQ);
            OPER_SYMS.put("!=", NumericMatcher.Op.NE);
        }
    }

    private static interface C {
        public void accept(String var1, String var2, boolean var3);
    }

    static class SubstringPropertyMatcher
    implements Properties.PropertyMatcher {
        private final String name;
        private final String substr;

        public SubstringPropertyMatcher(String name, String substr) {
            this.name = name;
            this.substr = substr.toLowerCase();
        }

        public String getName() {
            return this.name;
        }

        public boolean match(Object v) {
            if (this.substr == null || this.substr.isEmpty()) {
                return v == null;
            }
            if (v == null) {
                return false;
            }
            return v.toString().toLowerCase().contains(this.substr);
        }
    }

    static class NumericMatcher
    implements Properties.PropertyMatcher {
        private final String name;
        private final Op op;
        private final Number match;
        private float threshold = 0.01f;

        public NumericMatcher(String name, Op op, Number match) {
            this.name = name;
            this.op = op;
            this.match = match;
        }

        public String getName() {
            return this.name;
        }

        public boolean match(Object value) {
            int v;
            if (this.match == null) {
                return value == null;
            }
            if (value == null) {
                return false;
            }
            if (this.match instanceof Double) {
                double v2;
                double m = (Double)this.match;
                try {
                    v2 = Double.parseDouble(value.toString());
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                switch (this.op) {
                    case LT: {
                        return v2 < m;
                    }
                    case LE: {
                        return v2 <= m;
                    }
                    case GT: {
                        return v2 > m;
                    }
                    case GE: {
                        return v2 >= m;
                    }
                    case EQ: {
                        return Math.abs(v2 - m) < (double)this.threshold;
                    }
                    case NE: {
                        return Math.abs(v2 - m) >= (double)this.threshold;
                    }
                }
                return false;
            }
            int m = (Integer)this.match;
            try {
                v = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException ex) {
                return false;
            }
            switch (this.op) {
                case LT: {
                    return v < m;
                }
                case LE: {
                    return v <= m;
                }
                case GT: {
                    return v > m;
                }
                case GE: {
                    return v >= m;
                }
                case EQ: {
                    return v == m;
                }
                case NE: {
                    return v != m;
                }
            }
            return false;
        }

        public static enum Op {
            LT,
            LE,
            GT,
            GE,
            EQ,
            NE;

        }
    }
}

