/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.search.Bundle;

public class Criteria {
    private Properties.PropertyMatcher matcher;

    public Properties.PropertyMatcher getMatcher() {
        return this.matcher;
    }

    public Criteria setMatcher(Properties.PropertyMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public String toQueryString() {
        if (this.matcher == Properties.PropertyMatcher.ALL) {
            return "";
        }
        if (this.matcher instanceof Properties.RegexpPropertyMatcher) {
            String n = this.matcher.getName();
            Properties.RegexpPropertyMatcher rm = (Properties.RegexpPropertyMatcher)this.matcher;
            if (n.equals("name")) {
                return rm.getRegexpValue();
            }
            return n + "=" + rm.getRegexpValue();
        }
        return null;
    }

    public String toDisplayString(boolean allowHtml) {
        if (this.matcher == Properties.PropertyMatcher.ALL) {
            return Bundle.DISPLAY_CriteriaAll();
        }
        if (this.matcher instanceof Properties.RegexpPropertyMatcher) {
            String n = this.matcher.getName();
            Properties.RegexpPropertyMatcher rm = (Properties.RegexpPropertyMatcher)this.matcher;
            String rtext = this.unquoteRegexpValue(rm.getRegexpValue());
            if (n.equals("name")) {
                return Bundle.DISPLAY_CriteriaRegexpName(rtext);
            }
            return Bundle.DISPLAY_CriteriaRegexpPropertyValue(rtext, n);
        }
        return null;
    }

    private String unquoteRegexpValue(String val) {
        int start = val.indexOf("\\Q");
        if (start == -1) {
            return val;
        }
        int last = 0;
        StringBuilder res = new StringBuilder();
        while (start >= 0) {
            res.append(val.substring(last, start));
            int end = val.indexOf("\\E", start + 1);
            if (end < 0) {
                last = start;
            } else {
                res.append(val.substring(start + 2, end));
                last = end + 2;
            }
            start = val.indexOf("\\Q", last);
        }
        res.append(val.substring(last));
        return res.toString();
    }
}

