/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.search.GraphSearchEngine;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class SearchTask {
    private final RequestProcessor.Task task;
    private final GraphSearchEngine.SearchRunnable worker;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final SearchResultsModel model;

    SearchTask(SearchResultsModel model) {
        this.task = null;
        this.worker = null;
        this.model = model;
    }

    SearchTask(RequestProcessor.Task task, GraphSearchEngine.SearchRunnable worker, SearchResultsModel model) {
        this.task = task;
        this.worker = worker;
        this.model = model;
    }

    public static SearchTask finished(SearchResultsModel model) {
        return new SearchTask(model);
    }

    public Collection<InputGraph> pendingGraphs() {
        if (this.worker == null) {
            return Collections.emptySet();
        }
        return this.worker.getPendingGraphs();
    }

    public boolean cancel() {
        if (this.task == null) {
            return false;
        }
        if (this.cancelled.get()) {
            return true;
        }
        this.cancelled.compareAndSet(false, this.task.cancel() || this.worker.cancel());
        return this.cancelled.get();
    }

    public Task getTask() {
        return this.task == null ? Task.EMPTY : this.task;
    }

    public boolean isFinished() {
        return this.getTask().isFinished();
    }

    public boolean isCancelled() {
        return this.task != null && (this.cancelled.get() || this.worker.isCancelled());
    }

    public void addTaskListener(TaskListener tl) {
        if (this.task != null) {
            this.task.addTaskListener(tl);
        }
    }

    public void removeTaskListener(TaskListener tl) {
        if (this.task != null) {
            this.task.removeTaskListener(tl);
        }
    }

    public SearchResultsModel getModel() {
        return this.model;
    }
}

