/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.quicksearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.SuppressFBWarnings;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.search.Criteria;
import org.graalvm.visualizer.search.GraphSearchEngine;
import org.graalvm.visualizer.search.SimpleNodeProvider;
import org.graalvm.visualizer.search.quicksearch.Bundle;
import org.graalvm.visualizer.search.ui.SearchResultsView;
import org.graalvm.visualizer.util.LookupHistory;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class NodeQuickSearch
implements SearchProvider {
    private final int MAX_VALUE_LENGTH = 80;
    private static final String DEFAULT_PROPERTY = "name";

    private static DiagramViewer getActiveGraphProvider() {
        DiagramViewerLocator vwr = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        if (vwr == null) {
            return null;
        }
        return vwr.getActiveViewer();
    }

    public void evaluate(SearchRequest request, SearchResponse response) {
        InputGraphProvider p;
        String value;
        String name;
        String query = request.getText();
        if (query.trim().isEmpty()) {
            return;
        }
        String[] parts = query.split("=", 2);
        if (parts.length == 1) {
            name = DEFAULT_PROPERTY;
            value = Pattern.quote(parts[0]);
        } else {
            name = parts[0];
            value = parts[1];
        }
        if (value.isEmpty()) {
            value = ".*";
        }
        if ((p = (InputGraphProvider)LookupHistory.getLast(InputGraphProvider.class)) != null && p.getGraph() != null) {
            HashSet m;
            InputGraph matchGraph = p.getGraph();
            Pair<List<InputNode>, List<InputNode>> matches = this.findMatches(name, value, matchGraph, response);
            boolean moreResults = true;
            InputGraph theGraph = p.getGraph() != matchGraph ? matchGraph : null;
            HashSet hashSet = m = matches == null ? Collections.emptySet() : new HashSet((Collection)matches.second());
            if (!m.isEmpty()) {
                moreResults &= response.addResult(() -> {
                    DiagramViewer comp = NodeQuickSearch.getActiveGraphProvider();
                    if (comp != null) {
                        if (theGraph != null) {
                            comp.getModel().selectGraph(theGraph);
                        }
                        comp.setSelectedNodes(m);
                        comp.requestActive(true, false);
                    }
                }, theGraph != null ? Bundle.FMT_ExactMatchingNodesOther(m.size(), name, value, theGraph.getName()) : Bundle.FMT_ExactMatchingNodes(m.size(), name, value));
            }
            if (!(moreResults &= response.addResult(this.createSearchAction(p.getGraph(), p.getContainer(), name, value), Bundle.LABEL_OpenSearchResults(value)))) {
                return;
            }
            if (matches != null) {
                ArrayList allMatches = new ArrayList((Collection)matches.second());
                int exact = allMatches.size();
                allMatches.addAll((Collection)matches.first());
                int index = 0;
                for (InputNode n : allMatches) {
                    String val = this.trimValue(value, n.getProperties().get(name).toString(), index < exact);
                    String string = theGraph != null ? Bundle.FMT_NodeResultOther(val, n.getId(), n.getProperties().get(DEFAULT_PROPERTY), theGraph.getName()) : Bundle.FMT_NodeResult(val, n.getId(), n.getProperties().get(DEFAULT_PROPERTY));
                    ++index;
                    if (moreResults &= response.addResult(() -> {
                        DiagramViewer comp = NodeQuickSearch.getActiveGraphProvider();
                        if (comp != null) {
                            HashSet<InputNode> tmpSet = new HashSet<InputNode>();
                            tmpSet.add(n);
                            if (theGraph != null) {
                                comp.getModel().selectGraph(theGraph);
                            }
                            comp.setSelectedNodes(tmpSet);
                            comp.requestActive(true, false);
                        }
                    }, string)) continue;
                    break;
                }
            }
        }
    }

    private Runnable createSearchAction(InputGraph g, GraphContainer c, String name, String value) {
        return () -> {
            GraphSearchEngine engine = new GraphSearchEngine(c, g, new SimpleNodeProvider());
            SearchResultsView.addSearchResults(engine);
            Properties.RegexpPropertyMatcher matcher = new Properties.RegexpPropertyMatcher(name, value, false, 10);
            engine.newSearch(new Criteria().setMatcher((Properties.PropertyMatcher)matcher), false);
        };
    }

    String trimValue(String searchPattern, String value, boolean full) {
        int from = 0;
        int to = value.length();
        if (!searchPattern.contains("\\n")) {
            Pattern p = Pattern.compile(searchPattern, 10);
            Matcher m = p.matcher(value);
            if (full ? m.matches() : m.find()) {
                int s = m.start();
                int e = m.end();
                int f = value.lastIndexOf(10, s);
                int t = value.indexOf(10, e);
                value = value.substring(f + 1, t == -1 ? value.length() : t);
                from = s - f + 1;
                to = e - f + 1;
            }
        }
        if (value.length() < 80) {
            return value;
        }
        if (to - from > 80) {
            return value.substring(0, Math.min(80, value.length())) + "...";
        }
        int x = Math.max(0, from - (80 - (to - from)) / 2);
        return (x > 0 ? "..." : "") + value.substring(x, Math.min(value.length(), x + 80)) + "...";
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Ignored unlikely just warning msg failure")
    Pair<List<InputNode>, List<InputNode>> findMatches(String name, String value, InputGraph inputGraph, SearchResponse response) {
        try {
            Properties.RegexpPropertyMatcher matcher = new Properties.RegexpPropertyMatcher(name, value, false, 10);
            Properties.RegexpPropertyMatcher fullMatcher = new Properties.RegexpPropertyMatcher(name, value, true, 10);
            Properties.PropertySelector selector = new Properties.PropertySelector(inputGraph.getNodes());
            List matches = selector.selectMultiple((Properties.PropertyMatcher)matcher);
            Properties.PropertySelector fullSelector = new Properties.PropertySelector((Collection)matches);
            List fullMatches = fullSelector.selectMultiple((Properties.PropertyMatcher)fullMatcher);
            if (matches.isEmpty() && fullMatches.isEmpty()) {
                return null;
            }
            matches.removeAll(fullMatches);
            return Pair.of((Object)matches, (Object)fullMatches);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            response.addResult(() -> {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)Bundle.MSG_SearchExceptionOccured(msg), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }, Bundle.DESC_SearchError());
            return null;
        }
    }
}

