/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.awt.Image;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.ui.GraphNodeChildren;
import org.graalvm.visualizer.util.GraphTypes;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class GraphNode
extends AbstractNode {
    private final GraphItem item;
    private final SearchResultsModel model;
    private final InstanceContent content;
    private Image icon;
    private Image openedIcon;

    private GraphNode(SearchResultsModel model, GraphItem item, InstanceContent content) {
        super((Children)new GraphNodeChildren(model, item), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.item = item;
        this.model = model;
        this.setName(item.getDisplayName());
        this.content = content;
        content.add((Object)item);
    }

    public GraphNode(SearchResultsModel model, GraphItem item) {
        this(model, item, new InstanceContent());
    }

    public Image getIcon(int type) {
        if (this.icon == null) {
            GraphTypes tt = (GraphTypes)Lookup.getDefault().lookup(GraphTypes.class);
            Node n = tt.getTypeNode(this.item.getType());
            this.icon = n.getIcon(type);
        }
        return this.icon;
    }

    public Image getOpenedIcon(int type) {
        if (this.openedIcon == null) {
            GraphTypes tt = (GraphTypes)Lookup.getDefault().lookup(GraphTypes.class);
            Node n = tt.getTypeNode(this.item.getType());
            this.openedIcon = n.getOpenedIcon(type);
        }
        return this.openedIcon;
    }
}

