/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.util.Collection;
import java.util.EventListener;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.NodeResultItem;
import org.graalvm.visualizer.search.SearchResultsEvent;
import org.graalvm.visualizer.search.SearchResultsListener;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.ui.ItemNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class GraphNodeChildren
extends Children.Keys<NodeResultItem>
implements SearchResultsListener {
    private final SearchResultsModel model;
    private final GraphItem parent;
    private final SearchResultsListener wl;

    public GraphNodeChildren(SearchResultsModel model, GraphItem parent) {
        this.model = model;
        this.parent = parent;
        this.wl = (SearchResultsListener)WeakListeners.create(SearchResultsListener.class, (EventListener)this, (Object)model);
    }

    @Override
    public void itemsRemoved(SearchResultsEvent event) {
        this.refreshKeys();
    }

    @Override
    public void itemsAdded(SearchResultsEvent event) {
    }

    private void refreshKeys() {
        Collection<NodeResultItem> items = this.model.getChildren(this.parent);
        this.setKeys(items.toArray(new NodeResultItem[items.size()]));
    }

    protected void removeNotify() {
        if (this.wl != null) {
            this.model.removeParentListener(this.parent, this.wl);
        }
        super.removeNotify();
    }

    protected void addNotify() {
        super.addNotify();
        this.model.addParentListener(this.parent, this.wl);
        this.refreshKeys();
    }

    protected Node[] createNodes(NodeResultItem t) {
        return new Node[]{new ItemNode(this.model, t)};
    }
}

