/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.NodeResultItem;
import org.graalvm.visualizer.search.ResultItem;
import org.graalvm.visualizer.search.SearchResultsEvent;
import org.graalvm.visualizer.search.SearchResultsListener;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.ui.ResultsFlatChildren;
import org.graalvm.visualizer.search.ui.ResultsGraphChildren;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class RootSwitchNode
extends FilterNode
implements SearchResultsListener {
    private static final RequestProcessor RESELECT_RP = new RequestProcessor(RootSwitchNode.class);
    private final GraphContainer container;
    private final SearchResultsModel model;
    private final Node flatNode;
    private final Outline theOutline;
    private final ExplorerManager manager;
    private final NodeTreeModel nodeOutlineModel;
    private Node treeNode;
    private GraphItem singleParent;

    public RootSwitchNode(Outline theOutline, ExplorerManager manager, NodeTreeModel nodeOutlineModel, GraphContainer container, SearchResultsModel model) {
        super((Node)new AbstractNode((Children)new ResultsFlatChildren(model)));
        this.model = model;
        this.flatNode = this.getOriginal();
        this.container = container;
        this.nodeOutlineModel = nodeOutlineModel;
        this.manager = manager;
        this.theOutline = theOutline;
        model.addSearchResultsListener((SearchResultsListener)WeakListeners.create(SearchResultsListener.class, (EventListener)this, (Object)model));
    }

    @Override
    public void parentsChanged(SearchResultsEvent event) {
        Collection<GraphItem> graphs = this.model.getParents();
        Node nextNode = this.flatNode;
        if (graphs.size() > 1) {
            if (this.treeNode == null) {
                this.treeNode = new AbstractNode((Children)new ResultsGraphChildren(this.container, this.model));
            }
            nextNode = this.treeNode;
        } else if (graphs.size() == 1) {
            this.singleParent = graphs.iterator().next();
        }
        Node fNextNode = nextNode;
        if (nextNode != this.getOriginal()) {
            SwingUtilities.invokeLater(() -> {
                if (fNextNode != this.flatNode) {
                    this.postSynchronize();
                }
                this.changeOriginal(fNextNode, true);
            });
        }
    }

    private void postSynchronize() {
        if (this.singleParent == null) {
            return;
        }
        Node[] sel = this.manager.getSelectedNodes();
        ArrayList<NodeResultItem> items = new ArrayList<NodeResultItem>();
        boolean visible = false;
        for (Node n : sel) {
            NodeResultItem r = (NodeResultItem)n.getLookup().lookup(NodeResultItem.class);
            if (r == null) continue;
            items.add(r);
            TreeNode tn = Visualizer.findVisualizer((Node)n);
            TreePath p = new TreePath(this.nodeOutlineModel.getPathToRoot(tn));
            if (!this.theOutline.isVisible(p) || visible) continue;
            visible = true;
            if (items.size() <= 1) continue;
            items.add(0, (NodeResultItem)items.remove(items.size() - 1));
        }
        SynchronizeViewAndSelection r = new SynchronizeViewAndSelection(items, this.singleParent, visible);
        RESELECT_RP.post(() -> SwingUtilities.invokeLater(r), 100);
    }

    private class SynchronizeViewAndSelection
    implements Runnable {
        private final List<NodeResultItem> selectedGraphNodes;
        private final GraphItem currentGraph;
        private final boolean scrollToView;

        public SynchronizeViewAndSelection(List<NodeResultItem> selectedGraphNodes, GraphItem currentGraph, boolean scrollToView) {
            this.selectedGraphNodes = selectedGraphNodes;
            this.currentGraph = currentGraph;
            this.scrollToView = scrollToView;
        }

        @Override
        public void run() {
            this.expandAndSelect();
        }

        public void expandAndSelect() {
            Node graphNode = null;
            ArrayList<Node> toSelect = new ArrayList<Node>();
            Node root = RootSwitchNode.this.manager.getRootContext();
            if (root == null) {
                return;
            }
            for (Node n : root.getChildren().getNodes()) {
                if (n.getLookup().lookup(GraphItem.class) != this.currentGraph) continue;
                graphNode = n;
                break;
            }
            if (graphNode == null) {
                return;
            }
            for (Node n : graphNode.getChildren().getNodes()) {
                if (!this.selectedGraphNodes.contains(n.getLookup().lookup(ResultItem.class))) continue;
                toSelect.add(n);
            }
            TreeNode n = Visualizer.findVisualizer((Node)graphNode);
            TreePath expPath = new TreePath(RootSwitchNode.this.nodeOutlineModel.getPathToRoot(n));
            RootSwitchNode.this.theOutline.expandPath(expPath);
            Node[] nodeArr = toSelect.toArray(new Node[toSelect.size()]);
            try {
                RootSwitchNode.this.manager.setExploredContext(graphNode);
                RootSwitchNode.this.manager.setSelectedNodes(nodeArr);
            }
            catch (PropertyVetoException n2) {
                // empty catch block
            }
            if (this.scrollToView && nodeArr.length > 0) {
                TreeNode selNode = Visualizer.findVisualizer((Node)nodeArr[0]);
                TreePath visiblePath = new TreePath(RootSwitchNode.this.nodeOutlineModel.getPathToRoot(selNode));
                RootSwitchNode.this.theOutline.scrollRectToVisible(RootSwitchNode.this.theOutline.getPathBounds(visiblePath));
            }
        }
    }
}

