/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.SimpleProfileSelector;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.graalvm.visualizer.util.GraphTypes;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditProfilePanel
extends JPanel
implements ExplorerManager.Provider {
    private static final RequestProcessor DELAYER_RP = new RequestProcessor(EditProfilePanel.class);
    private final ProfileService profiles;
    private final ExplorerManager typeEM = new ExplorerManager();
    private FilterProfile profile;
    private NotificationLineSupport notifier;
    private boolean inputValid;
    private SimpleProfileSelector selector;
    private RequestProcessor.Task delayedInputValidation;
    private final DocumentListener dl = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            EditProfilePanel.this.inputChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            EditProfilePanel.this.inputChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };
    private JCheckBox graphRegexp;
    private JTextField groupNameText;
    private JCheckBox groupRegexp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField nameText;
    private JSpinner priorityNumber;
    private JTextField profileText;
    private JComboBox typeChooser;

    public EditProfilePanel(ProfileService profiles) {
        this.profiles = profiles;
        this.initComponents();
        GraphTypes types = (GraphTypes)Lookup.getDefault().lookup(GraphTypes.class);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(Bundle.PROFILE_AllGraphTypes());
        for (Node n : types.getCategoryNode().getChildren().getNodes(true)) {
            model.addElement((String)n);
        }
        this.typeChooser.setModel(model);
        this.typeChooser.setRenderer(new R());
        this.nameText.getDocument().addDocumentListener(this.dl);
        this.groupNameText.getDocument().addDocumentListener(this.dl);
        this.priorityNumber.addChangeListener(e -> this.inputChanged());
    }

    private void inputChanged() {
        if (this.delayedInputValidation != null) {
            this.delayedInputValidation.cancel();
        }
        this.delayedInputValidation = DELAYER_RP.post(() -> SwingUtilities.invokeLater(this::validateInputs), 200);
    }

    public boolean isInputValid() {
        return this.inputValid;
    }

    public SimpleProfileSelector getSelector() {
        return this.selector;
    }

    public void setSelector(SimpleProfileSelector selector) {
        this.selector = selector;
    }

    public ExplorerManager getExplorerManager() {
        return this.typeEM;
    }

    public void setProfile(FilterProfile profile) {
        this.profile = profile;
    }

    public void setNotifier(NotificationLineSupport notifier) {
        this.notifier = notifier;
    }

    public void editOnly() {
        this.profileText.setEditable(false);
    }

    public String getProfileName() {
        return this.profileText.getText();
    }

    public String getNameRegexp() {
        return this.nameText.getText();
    }

    public int getPriority() {
        return (Integer)this.priorityNumber.getValue();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.profileText.setText(this.profile.getName());
        boolean selEnable = this.selector.isValid();
        this.typeChooser.setEnabled(selEnable);
        this.nameText.setEnabled(selEnable);
        this.groupNameText.setEnabled(selEnable);
        this.priorityNumber.setEnabled(selEnable);
        this.graphRegexp.setEnabled(selEnable);
        this.groupRegexp.setEnabled(selEnable);
        this.graphRegexp.setSelected(this.selector.isGraphNameRegexp());
        this.groupRegexp.setSelected(this.selector.isOwnerNameRegexp());
        if (!selEnable) {
            return;
        }
        this.nameText.setText(this.selector.getGraphName());
        this.groupNameText.setText(this.selector.getOwnerName());
        this.priorityNumber.setValue(this.selector.getOrder());
        if (this.selector.getGraphType() == null) {
            this.typeChooser.setSelectedIndex(0);
        } else {
            for (int i = 1; i < this.typeChooser.getItemCount(); ++i) {
                Node n;
                Object o = this.typeChooser.getItemAt(i);
                if (!(o instanceof Node) || !(n = (Node)o).getName().equals(this.selector.getGraphType())) continue;
                this.typeChooser.setSelectedIndex(i);
                break;
            }
        }
    }

    void updateSelector() {
        String s = this.groupNameText.getText();
        this.selector.setOwnerName(s.trim());
        s = this.nameText.getText();
        this.selector.setGraphName(s.trim());
        Object o = this.priorityNumber.getValue();
        if (o instanceof Integer) {
            this.selector.setOrder(((Integer)o).intValue());
        } else {
            this.selector.setOrder(0);
        }
        o = this.typeChooser.getSelectedItem();
        if (o instanceof Node) {
            this.selector.setGraphType(((Node)o).getName());
        } else {
            this.selector.setGraphType(null);
        }
        this.selector.setGraphNameRegexp(this.graphRegexp.isSelected());
        this.selector.setOwnerNameRegexp(this.groupRegexp.isSelected());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.typeChooser = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.priorityNumber = new JSpinner();
        this.profileText = new JTextField();
        this.nameText = new JTextField();
        this.jLabel5 = new JLabel();
        this.groupNameText = new JTextField();
        this.graphRegexp = new JCheckBox();
        this.groupRegexp = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.jLabel2.text"));
        this.typeChooser.setToolTipText(NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.typeChooser.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.jLabel4.text"));
        this.priorityNumber.setFont(new Font("Dialog", 0, 12));
        this.priorityNumber.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1));
        this.priorityNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EditProfilePanel.this.priorityNumberFocusLost(evt);
            }
        });
        this.profileText.setText(NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.profileText.text"));
        this.nameText.setText(NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.nameText.text"));
        this.nameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EditProfilePanel.this.nameTextFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.jLabel5.text"));
        this.groupNameText.setText(NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.groupNameText.text"));
        this.groupNameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EditProfilePanel.this.groupNameTextFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.graphRegexp, (String)NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.graphRegexp.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.groupRegexp, (String)NbBundle.getMessage(EditProfilePanel.class, (String)"EditProfilePanel.groupRegexp.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typeChooser, 0, -1, Short.MAX_VALUE).addComponent(this.profileText).addComponent(this.nameText).addComponent(this.groupNameText).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupRegexp).addComponent(this.graphRegexp).addComponent(this.priorityNumber, -2, 47, -2)).addGap(0, 106, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.profileText, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.typeChooser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.nameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphRegexp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupNameText, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupRegexp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.priorityNumber, -2, -1, -2)).addContainerGap()));
    }

    private void nameTextFocusLost(FocusEvent evt) {
        this.validateInputs();
    }

    private void groupNameTextFocusLost(FocusEvent evt) {
        this.validateInputs();
    }

    private void priorityNumberFocusLost(FocusEvent evt) {
        this.validateInputs();
    }

    private void setInputValid(boolean b) {
        boolean old = this.inputValid;
        this.inputValid = b;
        this.firePropertyChange("inputValid", old, b);
    }

    void reportError(String e) {
        this.setInputValid(false);
        this.notifier.setErrorMessage(e);
    }

    void validateInputs() {
        Integer n;
        String profName = this.profileText.getText();
        if (!profName.trim().equals(this.profile.getName()) && this.profiles.getProfiles().stream().anyMatch(p -> p.getName().equalsIgnoreCase(profName) && p != this.profile)) {
            this.reportError(Bundle.ERROR_ProfileNameUsed(profName));
            return;
        }
        String exprText = this.nameText.getText().trim();
        if (!exprText.isEmpty() && this.graphRegexp.isSelected()) {
            try {
                Pattern.compile(exprText, 2);
            }
            catch (PatternSyntaxException ex) {
                this.reportError(Bundle.ERROR_ProfileBadNamePattern(ex.toString()));
                return;
            }
        }
        if (!(exprText = this.groupNameText.getText().trim()).isEmpty() && this.groupRegexp.isSelected()) {
            try {
                Pattern.compile(exprText, 2);
            }
            catch (PatternSyntaxException ex) {
                this.reportError(Bundle.ERROR_ProfileBadNamePattern(ex.toString()));
                return;
            }
        }
        if ((n = (Integer)this.priorityNumber.getModel().getValue()) != null && n < 0) {
            this.reportError(Bundle.ERROR_ProfileBadPriority());
            return;
        }
        this.setInputValid(true);
        this.notifier.clearMessages();
    }

    static class R
    extends DefaultListCellRenderer {
        private final ListCellRenderer delegate = new NodeRenderer();

        R() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Node) {
                return this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    static class TypeChildren
    extends FilterNode.Children {
        public TypeChildren(Node or) {
            super(or);
        }
    }
}

