/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.LocationStackFrame;
import jdk.graal.compiler.graphio.parsing.LocationStratum;

public class LocationCache {
    private static final WeakCache<LocationStratum> stratumCache = new WeakCache();
    private static final WeakCache<LocationStackFrame> stackFrameCache = new WeakCache();

    public static List<LocationStratum> fileLineStratum(String fileName, int line) {
        return Collections.nCopies(1, LocationCache.createStratum(null, fileName, "Java", line, -1, -1));
    }

    public static LocationStratum createStratum(String uri, String file, String language, int line, int startOffset, int endOffset) {
        return stratumCache.get(new LocationStratum(uri, file, language, line, startOffset, endOffset));
    }

    public static LocationStackFrame createFrame(BinaryReader.Method method, int bci, List<LocationStratum> strata, LocationStackFrame parent) {
        return stackFrameCache.get(new LocationStackFrame(method, bci, strata, parent));
    }

    public static BinaryReader.Method createMethod(String methodName, String className, byte[] bytecode) {
        BinaryReader.Klass clazz = className == null ? null : new BinaryReader.Klass(className);
        return new BinaryReader.Method(methodName, null, bytecode, clazz, 0);
    }

    private static final class WeakCache<T> {
        WeakHashMap<T, WeakReference<T>> immutableCache = new WeakHashMap();

        private WeakCache() {
        }

        synchronized T get(T value) {
            Object ref;
            WeakReference<T> result = this.immutableCache.get(value);
            if (result != null && (ref = result.get()) != null) {
                return ref;
            }
            this.immutableCache.put(value, new WeakReference<T>(value));
            return value;
        }
    }
}

