/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.lang.reflect.Array;
import java.util.Objects;

public class Property<T> {
    private final String name;
    private final T value;

    public Property(String name, T value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name must not be null!");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return Property.toString(this.name, this.value);
    }

    public static <T> String toString(String name, T value) {
        StringBuilder sb = new StringBuilder(name).append("=");
        if (value == null || !value.getClass().isArray()) {
            sb.append(value);
        } else {
            sb.append("[");
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                sb.append(Array.get(value, i)).append(", ");
            }
            sb.setLength(sb.length() == 1 ? 1 : sb.length() - 2);
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Property)) {
            return false;
        }
        Property p2 = (Property)o;
        return this.name.equals(p2.name) && Objects.deepEquals(this.value, p2.value);
    }

    public int hashCode() {
        return Property.makeHash(this.name, this.value);
    }

    protected static <T> int makeHash(String name, T value) {
        int hash = name.hashCode();
        if (value == null || !value.getClass().isArray()) {
            return hash * 3 + Objects.hashCode(value);
        }
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            hash = hash * 3 + Objects.hashCode(Array.get(value, i));
        }
        return hash;
    }
}

