/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.InputNode;

public class Source {
    private static final int SET_THRESHOLD = 20;
    private Object sources;
    private boolean many;
    private Set<Integer> set;

    private boolean hasMany() {
        return this.many;
    }

    public boolean isEmpty() {
        return this.sources == null;
    }

    private List<InputNode> list() {
        assert (this.hasMany());
        return (List)this.sources;
    }

    public InputNode first() {
        if (this.hasMany()) {
            return this.list().get(0);
        }
        return (InputNode)this.sources;
    }

    private Set<Integer> createIdSet() {
        if (this.set == null) {
            this.set = new HashSet<Integer>();
            for (InputNode n : this.list()) {
                this.set.add(n.getId());
            }
        }
        return this.set;
    }

    public int firstId() {
        return this.sources == null ? -1 : this.first().getId();
    }

    public List<InputNode> getSourceNodes() {
        if (this.hasMany()) {
            return Collections.unmodifiableList((List)this.sources);
        }
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList((InputNode)this.sources);
    }

    public final Set<Integer> getSourceNodeIds() {
        return this.collectIds(new HashSet());
    }

    public <T extends Collection<Integer>> T collectIds(T col) {
        assert (col != null);
        if (this.hasMany()) {
            for (InputNode n : this.list()) {
                col.add(n.getId());
            }
        } else if (!this.isEmpty()) {
            col.add(((InputNode)this.sources).getId());
        }
        return col;
    }

    @Deprecated
    public Set<Integer> getSourceNodesAsSet() {
        if (this.hasMany()) {
            return Collections.unmodifiableSet(this.createIdSet());
        }
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(((InputNode)this.sources).getId());
    }

    public void addSourceNode(InputNode n) {
        List<InputNode> nodes;
        if (this.isEmpty()) {
            this.sources = n;
            return;
        }
        if (!this.hasMany()) {
            if (this.sources == n) {
                return;
            }
            InputNode existing = (InputNode)this.sources;
            nodes = new ArrayList<InputNode>(2);
            this.sources = nodes;
            nodes.add(existing);
            this.many = true;
        } else {
            nodes = this.list();
            if (nodes.size() < 20 ? nodes.contains(n) : this.createIdSet().contains(n.getId())) {
                return;
            }
        }
        nodes.add(n);
        if (this.set != null) {
            this.set.add(n.getId());
        }
    }

    public void addSourceNodes(Source s) {
        for (InputNode n : s.getSourceNodes()) {
            this.addSourceNode(n);
        }
    }

    public void replaceFrom(Source source) {
        if (source.hasMany()) {
            ArrayList<InputNode> nodes;
            this.sources = nodes = new ArrayList<InputNode>(source.list());
            this.many = true;
            if (nodes.size() > 20) {
                this.set = new HashSet<Integer>();
                for (InputNode n : nodes) {
                    this.set.add(n.getId());
                }
            }
        } else {
            this.sources = source.sources;
            this.many = false;
        }
    }

    public static interface Provider {
        public Source getSource();
    }
}

