/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Group;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;

public final class CancelableSource
extends BinarySource
implements ParseMonitor {
    private final StreamEntry entry;
    private final Group.Feedback feedback;
    private final ParseMonitor delegate;

    public CancelableSource(Object id, ParseMonitor delegate, ReadableByteChannel channel) {
        super(id, channel);
        this.delegate = delegate;
        this.entry = null;
        this.feedback = null;
    }

    CancelableSource(Object id, StreamEntry entry, Group.Feedback feedback, ReadableByteChannel channel) {
        super(id, channel);
        this.entry = entry;
        this.feedback = feedback;
        this.delegate = null;
    }

    private int pos() {
        return (int)this.getMarkRelative();
    }

    @Override
    public void updateProgress() {
        if (this.feedback != null) {
            this.feedback.reportProgress(this.pos(), (int)this.entry.unfinishedSize(), null);
        }
    }

    @Override
    public void setState(String state) {
        if (this.feedback != null) {
            this.feedback.reportProgress(this.pos(), (int)this.entry.unfinishedSize(), state);
        }
    }

    @Override
    public boolean isCancelled() {
        if (this.feedback != null) {
            return this.feedback.isCancelled();
        }
        if (this.delegate != null) {
            return this.delegate.isCancelled();
        }
        return false;
    }

    @Override
    protected void fill() throws IOException {
        if (this.isCancelled()) {
            throw new InterruptedIOException();
        }
        super.fill();
    }

    @Override
    public void reportError(List<FolderElement> parents, List<String> parentNames, String name, String errorMessage) {
        if (this.feedback != null) {
            this.feedback.reportError(parents, parentNames, name, errorMessage);
        } else if (this.delegate != null) {
            this.delegate.reportError(parents, parentNames, name, errorMessage);
        }
    }
}

