/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.data.serialization.lazy.BaseCompleter;
import org.graalvm.visualizer.data.serialization.lazy.Env;
import org.graalvm.visualizer.data.serialization.lazy.GraphBuilder;
import org.graalvm.visualizer.data.serialization.lazy.LazyGraph;
import org.graalvm.visualizer.data.serialization.lazy.ParseMonitorBridge;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;

final class GraphCompleter
extends BaseCompleter<InputGraph.GraphData, LazyGraph> {
    public GraphCompleter(Env env, StreamEntry entry) {
        super(env, entry);
    }

    @Override
    protected InputGraph.GraphData hookData(InputGraph.GraphData data) {
        return data;
    }

    @Override
    protected InputGraph.GraphData createEmpty() {
        return new InputGraph.GraphData();
    }

    @Override
    protected InputGraph.GraphData load(ReadableByteChannel channel, int majorVersion, int minorVersion, Group.Feedback feedback) throws IOException {
        GraphDocument doc = new GraphDocument();
        BinarySource bs = new BinarySource(channel, majorVersion, minorVersion, this.entry.getStart());
        GraphBuilder builder = new GraphBuilder(doc, (InputGraph)((Object)this.toComplete), this.future(), this.entry, new ParseMonitorBridge(this.entry, feedback, bs));
        new BinaryReader(bs, builder).parse();
        return builder.data();
    }
}

