/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import jdk.graal.compiler.graphio.parsing.DocumentFactory;
import jdk.graal.compiler.graphio.parsing.ModelBuilder;
import jdk.graal.compiler.graphio.parsing.NameTranslator;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import jdk.graal.compiler.graphio.parsing.model.Property;
import org.graalvm.visualizer.data.serialization.BinaryMap;
import org.graalvm.visualizer.data.serialization.lazy.ReaderErrors;

public class LazyModelBuilder
extends ModelBuilder {
    public LazyModelBuilder(GraphDocument rootDocument, ParseMonitor monitor) {
        super(rootDocument, monitor);
    }

    public LazyModelBuilder(DocumentFactory factory, ParseMonitor monitor) {
        super(factory, monitor);
    }

    @Override
    public NameTranslator prepareNameTranslator() {
        BinaryMap versions = BinaryMap.versions();
        Properties.Entity versionHolder = this.folder() != null ? (Properties.Entity)((Object)this.folder()) : this.getEntity();
        String PREFIX = "version.";
        for (Property p : versionHolder.getProperties()) {
            if (!p.getName().startsWith("version.")) continue;
            versions.request(p.getName().substring("version.".length()), p.getValue().toString());
        }
        return versions;
    }

    @Override
    public void reportLoadingError(String logMessage) {
        super.reportLoadingError(logMessage);
        FolderElement parent = this.graph();
        Folder folder = this.folder();
        if (parent == null) {
            parent = folder;
            folder = null;
        }
        ReaderErrors.addError(parent, folder, logMessage);
    }
}

