/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import jdk.graal.compiler.graphio.parsing.DocumentFactory;
import jdk.graal.compiler.graphio.parsing.ModelBuilder;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputEdge;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.serialization.lazy.CachedContent;
import org.graalvm.visualizer.data.serialization.lazy.Env;
import org.graalvm.visualizer.data.serialization.lazy.GraphMetadata;
import org.graalvm.visualizer.data.serialization.lazy.GroupCompleter;
import org.graalvm.visualizer.data.serialization.lazy.LazyGroup;
import org.graalvm.visualizer.data.serialization.lazy.LazyModelBuilder;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;
import org.graalvm.visualizer.data.serialization.lazy.StreamIndex;
import org.graalvm.visualizer.data.serialization.lazy.StreamPool;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.util.WeakSet;

public class ScanningModelBuilder
extends LazyModelBuilder {
    private static final Logger LOG = Logger.getLogger(ScanningModelBuilder.class.getName());
    private final CachedContent streamContent;
    private final BinarySource dataSource;
    private final Map<Group, GroupCompleter> completors = new LinkedHashMap<Group, GroupCompleter>();
    private final ScheduledExecutorService fetchExecutor;
    private final Properties dummyProperties = new Properties.ArrayProperties(){

        @Override
        protected void setPropertyInternal(String name, Object value) {
        }
    };
    int groupLevel;
    private int graphLevel;
    private GroupCompleter completer;
    protected final StreamIndex index = new StreamIndex();
    private final Deque<StreamEntry> entryStack = new LinkedList<StreamEntry>();
    private StreamEntry entry;
    private Cleaner cleaner;
    private String currentGroupName;
    private long rootStartPos;
    private String tlGraphName;
    private boolean scanGraph;

    public ScanningModelBuilder(BinarySource dataSource, CachedContent content, GraphDocument rootDocument, ParseMonitor monitor, ScheduledExecutorService fetchExecutor) {
        this(dataSource, content, rootDocument, monitor, fetchExecutor, new StreamPool());
    }

    public ScanningModelBuilder(BinarySource dataSource, CachedContent content, DocumentFactory rootDocumentFactory, ParseMonitor monitor, ScheduledExecutorService fetchExecutor) {
        this(dataSource, content, rootDocumentFactory, monitor, fetchExecutor, new StreamPool());
    }

    ScanningModelBuilder(BinarySource dataSource, CachedContent content, GraphDocument rootDocument, ParseMonitor monitor, ScheduledExecutorService fetchExecutor, StreamPool initialPool) {
        super(rootDocument, monitor);
        this.dataSource = dataSource;
        this.streamContent = content;
        this.replacePool(initialPool);
        this.fetchExecutor = fetchExecutor;
        this.initCleaner();
    }

    ScanningModelBuilder(BinarySource dataSource, CachedContent content, DocumentFactory rootDocumentFactory, ParseMonitor monitor, ScheduledExecutorService fetchExecutor, StreamPool initialPool) {
        super(rootDocumentFactory, monitor);
        this.dataSource = dataSource;
        this.streamContent = content;
        this.replacePool(initialPool);
        this.fetchExecutor = fetchExecutor;
        this.initCleaner();
    }

    private void initCleaner() {
        if (this.cleaner == null && this.rootDocument() != null) {
            this.cleaner = new Cleaner(this.rootDocument(), this.streamContent);
            this.rootDocument().getChangedEvent().addListener(this.cleaner);
        }
    }

    protected StreamPool pool() {
        return (StreamPool)this.getConstantPool();
    }

    private void documentUpdatedExternally() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerToParent(Folder parent, FolderElement element) {
        if (!(parent instanceof GraphDocument)) {
            return;
        }
        if (element instanceof LazyGroup) {
            CachedContent cachedContent = this.streamContent;
            synchronized (cachedContent) {
                this.cleaner.scannedGroups.put(element, Boolean.TRUE);
                long s = this.entry.getStart();
                this.cleaner.bumpOffset(s);
            }
        }
        super.registerToParent(parent, element);
    }

    @Override
    public void makeBlockEdges() {
    }

    @Override
    public void addBlockEdge(int from, int to) {
    }

    @Override
    public void addNodeToBlock(int nodeId) {
    }

    @Override
    @CheckForNull
    public Properties getNodeProperties(int nodeId) {
        return this.dummyProperties;
    }

    @Override
    @CheckForNull
    public InputBlock startBlock(int id) {
        return null;
    }

    @Override
    public void makeGraphEdges() {
    }

    @Override
    public InputEdge immutableEdge(char fromIndex, char toIndex, int from, int to, int listIndex, String label, String type) {
        return null;
    }

    @Override
    public void successorEdge(Builder.Port p, int from, int to, char num, int index) {
        if (this.scanGraph && from >= 0) {
            this.entry.getGraphMeta().addEdge(from, to);
        }
    }

    @Override
    public void inputEdge(Builder.Port p, int from, int to, char num, int index) {
        if (this.scanGraph && from >= 0) {
            this.entry.getGraphMeta().addEdge(from, to);
        }
    }

    @Override
    public void setNodeProperty(String key, Object value) {
    }

    @Override
    public void setNodeName(Builder.NodeClass nodeClass) {
    }

    @Override
    public void setGroupName(String name, String shortName) {
        if (this.groupLevel == 1) {
            super.setGroupName(name, shortName);
            this.completer.attachTo((LazyGroup)this.folder(), name);
        }
        this.currentGroupName = name;
        this.reportState(name);
    }

    @Override
    public void endNode(int nodeId) {
    }

    @Override
    public void startRoot() {
        super.startRoot();
        this.rootStartPos = this.dataSource.getMark();
    }

    @Override
    public void startNode(int nodeId, boolean hasPredecessors, Builder.NodeClass nodeClass) {
        if (this.scanGraph) {
            this.entry.getGraphMeta().addNode(nodeId);
        }
    }

    @Override
    public void markGraphDuplicate() {
        this.entry.getGraphMeta().markDuplicate();
    }

    protected void registerEntry(StreamEntry en, long pos) {
        StreamPool n = this.pool().forkIfNeeded();
        if (LOG.isLoggable(Level.FINER) && n != this.pool()) {
            LOG.log(Level.FINER, "Replaced pool {0} for {1}", new Object[]{Integer.toHexString(System.identityHashCode(this.pool())), Integer.toHexString(System.identityHashCode(n))});
        }
        this.replacePool(n);
        en.end(pos, n);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "{0} Entry {1}:{2}", new Object[]{this.logIndent(), en.getStart(), en.getEnd()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endGroup() {
        this.registerEntry(this.entry, this.rootStartPos);
        if (--this.groupLevel == 0) {
            LazyGroup g = (LazyGroup)this.folder();
            this.completer.end(this.entry.getEnd());
            super.endGroup();
            this.completer = null;
            CachedContent cachedContent = this.streamContent;
            synchronized (cachedContent) {
                if (this.cleaner.scannedGroups.containsKey(g)) {
                    long e = this.entry.getEnd();
                    this.cleaner.bumpOffset(e);
                }
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "{2} Group {0}, start = {3}, start = {1}", new Object[]{this.currentGroupName, this.entry.getEnd(), this.logIndent(), this.entry.getStart()});
        }
        this.entry = this.entryStack.pop();
    }

    @Override
    protected void rootDocumentResolved(GraphDocument doc) {
        super.rootDocumentResolved(doc);
        this.initCleaner();
    }

    @Override
    public void startGroupContent() {
        if (this.groupLevel == 1) {
            super.startGroupContent();
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "{2} Group {0}, start = {1}", new Object[]{this.currentGroupName, this.rootStartPos, this.logIndent()});
            }
        }
    }

    @Override
    @CheckForNull
    public Group startGroup() {
        GroupCompleter grc;
        this.checkConstantPool();
        this.entryStack.push(this.entry);
        this.entry = this.addEntry(new StreamEntry(this.streamContent.id(), this.dataSource.getMajorVersion(), this.dataSource.getMinorVersion(), this.rootStartPos, this.forkPool()));
        if (this.groupLevel++ > 0) {
            return null;
        }
        assert (this.completer == null);
        this.completer = grc = this.createCompleter(this.rootStartPos);
        LazyGroup g = new LazyGroup(this.folder(), grc, this.entry);
        this.completer.attachTo(g, null);
        this.completors.put(g, grc);
        return this.pushGroup(g, true);
    }

    @Override
    @CheckForNull
    public InputGraph startGraph(int dumpId, String format, Object[] args) {
        this.checkConstantPool();
        this.entryStack.push(this.entry);
        this.entry = this.addEntry(new StreamEntry(this.streamContent.id(), this.dataSource.getMajorVersion(), this.dataSource.getMinorVersion(), this.rootStartPos, this.forkPool()).setMetadata(new GraphMetadata()));
        ++this.graphLevel;
        this.scanGraph = false;
        if (this.graphLevel == 1) {
            this.tlGraphName = ModelBuilder.makeGraphName(dumpId, format, args);
            LOG.log(Level.FINER, "Starting graph {0} at {1}", new Object[]{this.tlGraphName, this.rootStartPos});
            this.scanGraph = true;
        }
        this.reportProgress();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        super.end();
        this.index.close();
        CachedContent cachedContent = this.streamContent;
        synchronized (cachedContent) {
            this.cleaner.finished = true;
        }
        LOG.log(Level.FINE, "Scan terminated");
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    @CheckForNull
    public InputGraph endGraph() {
        this.registerEntry(this.entry, this.dataSource.getMark());
        --this.graphLevel;
        if (this.graphLevel == 0) {
            LOG.log(Level.FINER, "Graph {0} ends at {1}, contains {2} nodes", new Object[]{this.tlGraphName, this.dataSource.getMark(), this.entry.getGraphMeta().getNodeCount()});
        }
        this.scanGraph = this.graphLevel == 1;
        this.entry = this.entryStack.pop();
        return null;
    }

    @Override
    public void startNestedProperty(String propertyKey) {
    }

    @Override
    public void setProperty(String key, Object value) {
        Folder f = this.folder();
        if (f == this.rootDocument() || f instanceof LazyGroup && this.graphLevel == 0) {
            super.setProperty(key, value);
        }
    }

    private void checkConstantPool() {
        assert (this.getReaderPool() == this.getConstantPool());
    }

    private String logIndent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.groupLevel; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public ConstantPool forkPool() {
        StreamPool sp = this.pool();
        StreamPool np = sp.forkIfNeeded();
        this.replacePool(np);
        return np;
    }

    protected StreamEntry addEntry(StreamEntry m) {
        StreamEntry e = this.index.addEntry(m);
        return e;
    }

    GroupCompleter getCompleter(Group g) {
        return this.completors.get(g);
    }

    GroupCompleter createCompleter(long start) {
        return new GroupCompleter(new Env(this.streamContent, this.fetchExecutor), this.index, this.entry);
    }

    private static class Cleaner
    implements ChangedListener<GraphDocument> {
        private final GraphDocument rootDocument;
        private final CachedContent streamContent;
        private final Set<GraphDocument> documents = new WeakSet();
        final Map<FolderElement, Boolean> scannedGroups = new WeakHashMap<FolderElement, Boolean>();
        long lastGroupOffset;
        boolean finished;

        public Cleaner(GraphDocument doc, CachedContent streamContent) {
            this.rootDocument = doc;
            this.streamContent = streamContent;
            this.documents.add(doc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changed(GraphDocument source) {
            ArrayList<GraphDocument> docs;
            HashSet<FolderElement> c;
            CachedContent cachedContent = this.streamContent;
            synchronized (cachedContent) {
                c = new HashSet<FolderElement>(this.scannedGroups.keySet());
                docs = new ArrayList<GraphDocument>(this.documents);
            }
            boolean someRemoved = false;
            for (GraphDocument rd : docs) {
                List<? extends FolderElement> els = rd.getElements();
                if (c.removeAll(els)) {
                    someRemoved = true;
                    continue;
                }
                CachedContent cachedContent2 = this.streamContent;
                synchronized (cachedContent2) {
                    rd.getChangedEvent().removeListener(this);
                    this.documents.remove(rd);
                }
            }
            HashSet<GraphDocument> newParents = new HashSet<GraphDocument>();
            Iterator itfe = c.iterator();
            while (itfe.hasNext()) {
                FolderElement fe = (FolderElement)itfe.next();
                Folder f = fe.getParent();
                if (docs.contains(f) || !f.getElements().contains(fe)) continue;
                if (f instanceof GraphDocument) {
                    newParents.add((GraphDocument)f);
                }
                itfe.remove();
            }
            CachedContent cachedContent3 = this.streamContent;
            synchronized (cachedContent3) {
                this.scannedGroups.keySet().removeAll(c);
                for (GraphDocument gd : newParents) {
                    if (!this.documents.add(gd)) continue;
                    gd.getChangedEvent().addListener(this);
                }
                if (someRemoved || !this.scannedGroups.isEmpty() || !newParents.isEmpty()) {
                    return;
                }
                this.streamContent.resetCache(this.lastGroupOffset);
                if (!this.streamContent.isOpen() && this.finished) {
                    this.rootDocument.getChangedEvent().removeListener(this);
                }
            }
        }

        void bumpOffset(long s) {
            this.lastGroupOffset = Math.max(s, this.lastGroupOffset);
        }
    }
}

