/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graal.filters;

import java.util.HashSet;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;

public class GraalCFGFilter
extends AbstractFilter {
    public String getName() {
        return "Graal CFG Filter";
    }

    public void apply(Diagram d) {
        HashSet<Connection> connectionsToRemove = new HashSet<Connection>();
        for (Figure f : d.getFigures()) {
            Properties p = f.getProperties();
            int predCount = -1;
            String predCountString = p.getString("predecessorCount", null);
            if (predCountString != null) {
                try {
                    predCount = Integer.parseInt(predCountString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (predCount == -1) {
                predCount = Boolean.parseBoolean(p.getString("hasPredecessor", null)) ? 1 : 0;
            }
            for (InputSlot is : f.getInputSlots()) {
                if (is.getPosition() < predCount || "EndNode".equals(is.getProperties().get("class", String.class))) continue;
                for (Connection c : is.getConnections()) {
                    if ("EndNode".equals(c.getOutputSlot().getFigure().getProperties().get("class", String.class))) continue;
                    connectionsToRemove.add(c);
                }
            }
        }
        for (Connection c : connectionsToRemove) {
            c.remove();
        }
        HashSet<Figure> figuresToRemove = new HashSet<Figure>();
        block6: for (Figure f : d.getFigures()) {
            for (InputSlot is : f.getInputSlots()) {
                if (is.getConnections().isEmpty()) continue;
                continue block6;
            }
            for (OutputSlot os : f.getOutputSlots()) {
                if (os.getConnections().isEmpty()) continue;
                continue block6;
            }
            figuresToRemove.add(f);
        }
        d.removeAllFigures(figuresToRemove);
    }
}

