/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graal.filters;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;

public class GraalEdgeColorFilter
extends AbstractFilter {
    private final HashMap<String, Color> usageColor = new HashMap();
    private Color otherUsageColor = Color.BLACK;

    public String getName() {
        return "Graal Edge Color Filter";
    }

    public void apply(Diagram d) {
        Collection figures = d.getFigures();
        for (Figure f : figures) {
            for (InputSlot is : f.getInputSlots()) {
                for (Connection c : is.getConnections()) {
                    String type = c.getType();
                    if ("Association".equals(type) && "EndNode".equals(c.getOutputSlot().getFigure().getProperties().get("class", String.class))) {
                        type = "Successor";
                    }
                    if (type == null) continue;
                    Color typeColor = this.usageColor.get(type);
                    if (typeColor == null) {
                        c.setColor(this.otherUsageColor);
                    } else {
                        c.setColor(typeColor);
                    }
                    if (c.getStyle() == Connection.ConnectionStyle.DASHED || !"Successor".equals(type)) continue;
                    c.setStyle(Connection.ConnectionStyle.BOLD);
                }
            }
        }
    }

    public Color getUsageColor(String type) {
        return this.usageColor.get(type);
    }

    public void setUsageColor(String type, Color usageColor) {
        this.usageColor.put(type, usageColor);
    }

    public Color getOtherUsageColor() {
        return this.otherUsageColor;
    }

    public void setOtherUsageColor(Color otherUsageColor) {
        this.otherUsageColor = otherUsageColor;
    }
}

