/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.java.ui;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualizer.source.FileRegistry;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.java.ui.Bundle;
import org.graalvm.visualizer.source.java.ui.ProjectContentPanel;
import org.graalvm.visualizer.source.spi.LocatorUI;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class JavaProjectLocatorUI
implements LocatorUI {
    public String getDisplayName() {
        return Bundle.LBL_LocateInJavaProject();
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/graalvm/visualizer/source/resources/j2seproject.png");
    }

    public boolean accepts(Location l) {
        return l.getMimeType().equals("text/x-java");
    }

    public Future<Boolean> resolve(Location l) {
        CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
        SwingUtilities.invokeLater(new LocatorRunner(cf, l));
        return cf;
    }

    static FileObject findSourceFile(Project p, String fileName, AtomicReference<FileObject> pathRoot) {
        ClassPath srcPath = ClassPath.getClassPath((FileObject)p.getProjectDirectory(), (String)"classpath/source");
        if (srcPath != null) {
            return srcPath.findResource(fileName);
        }
        Sources src = (Sources)p.getLookup().lookup(Sources.class);
        if (src == null) {
            return null;
        }
        for (SourceGroup sg : src.getSourceGroups("java")) {
            FileObject found;
            FileObject root = sg.getRootFolder();
            ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
            FileObject fileObject = found = cp == null ? null : cp.findResource(fileName);
            if (found == null) continue;
            if (pathRoot != null) {
                pathRoot.set(root);
            }
            return found;
        }
        return null;
    }

    private class LocatorRunner
    extends FileFilter
    implements Runnable {
        private final CompletableFuture future;
        private final Location loc;

        public LocatorRunner(CompletableFuture future, Location loc) {
            this.future = future;
            this.loc = loc;
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            FileObject fo = FileUtil.toFileObject((File)f);
            Project selected = FileOwnerQuery.getOwner((FileObject)fo);
            if (selected == null) {
                return fo.isFolder();
            }
            return JavaProjectLocatorUI.findSourceFile(selected, this.loc.getFileName(), null) != null;
        }

        @Override
        public String getDescription() {
            return Bundle.Filter_JavaProjects();
        }

        @Override
        public void run() {
            try {
                JFileChooser projectChooser = ProjectChooser.projectChooser();
                projectChooser.setCurrentDirectory(ProjectChooser.getProjectsFolder());
                projectChooser.setFileFilter(this);
                projectChooser.setMultiSelectionEnabled(true);
                projectChooser.setAcceptAllFileFilterUsed(false);
                projectChooser.setAccessory(new ProjectContentPanel(this.loc, projectChooser));
                if (projectChooser.showOpenDialog(null) != 0) {
                    this.future.complete(false);
                    return;
                }
                ProjectChooser.setProjectsFolder((File)projectChooser.getCurrentDirectory());
                File[] files = projectChooser.getSelectedFiles();
                ArrayList<Project> prjs = new ArrayList<Project>();
                for (int i = 0; i < files.length; ++i) {
                    FileObject fob = FileUtil.toFileObject((File)files[i]);
                    try {
                        Project p = ProjectManager.getDefault().findProject(fob);
                        if (p == null) continue;
                        prjs.add(p);
                        continue;
                    }
                    catch (IOException | IllegalStateException exception) {
                        // empty catch block
                    }
                }
                OpenProjects.getDefault().open(prjs.toArray(new Project[prjs.size()]), true, true);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OpenProjects.getDefault().openProjects().get();
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            LocatorRunner.this.future.completeExceptionally(ex);
                            return;
                        }
                        FileRegistry.getInstance().attemptResolve(LocatorRunner.this.loc.getFile());
                        LocatorRunner.this.future.complete(true);
                    }
                });
            }
            catch (Exception ex) {
                this.future.completeExceptionally(ex);
            }
        }
    }
}

