/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.java.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.java.ui.JavaProjectLocatorUI;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ProjectContentPanel
extends JPanel
implements PropertyChangeListener {
    private final Location loc;
    private final JFileChooser chooser;
    private JTextField fileName;
    private JLabel foundIn;
    private JPanel foundPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel missingPanel;
    private JPanel outcomeHolder;

    public ProjectContentPanel(Location loc, JFileChooser chooser) {
        this.loc = loc;
        this.chooser = chooser;
        this.initComponents();
        String spec = loc.getFile().getFileSpec();
        int last = spec.lastIndexOf("/");
        String simple = last == -1 ? spec : spec.substring(last + 1);
        this.fileName.setText(simple);
        chooser.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    private void notFound() {
        ((CardLayout)this.outcomeHolder.getLayout()).show(this.outcomeHolder, "missing");
    }

    private void found(String where) {
        this.foundIn.setText(where);
        ((CardLayout)this.outcomeHolder.getLayout()).show(this.outcomeHolder, "found");
    }

    private void refresh() {
        File f = this.chooser.getSelectedFile();
        if (f == null) {
            this.notFound();
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)f);
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            this.notFound();
            return;
        }
        AtomicReference<FileObject> fRoot = new AtomicReference<FileObject>();
        if (JavaProjectLocatorUI.findSourceFile(p, this.loc.getFileName(), fRoot) != null) {
            FileObject root = fRoot.get();
            FileObject prjDir = p.getProjectDirectory();
            String rel = FileUtil.getRelativePath((FileObject)prjDir, (FileObject)root);
            this.found(rel);
        } else {
            this.notFound();
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.outcomeHolder = new JPanel();
        this.foundPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.foundIn = new JLabel();
        this.missingPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.fileName = new JTextField();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProjectContentPanel.class, (String)"ProjectContentPanel.jLabel3.text"));
        this.outcomeHolder.setLayout(new CardLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectContentPanel.class, (String)"ProjectContentPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.foundIn, (String)NbBundle.getMessage(ProjectContentPanel.class, (String)"ProjectContentPanel.foundIn.text"));
        GroupLayout foundPanelLayout = new GroupLayout(this.foundPanel);
        this.foundPanel.setLayout(foundPanelLayout);
        foundPanelLayout.setHorizontalGroup(foundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(foundPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.foundIn, -1, 106, Short.MAX_VALUE).addContainerGap()));
        foundPanelLayout.setVerticalGroup(foundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(foundPanelLayout.createSequentialGroup().addContainerGap().addGroup(foundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.foundIn, -1, -1, Short.MAX_VALUE)).addContainerGap(50, Short.MAX_VALUE)));
        this.outcomeHolder.add((Component)this.foundPanel, "found");
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectContentPanel.class, (String)"ProjectContentPanel.jLabel4.text"));
        GroupLayout missingPanelLayout = new GroupLayout(this.missingPanel);
        this.missingPanel.setLayout(missingPanelLayout);
        missingPanelLayout.setHorizontalGroup(missingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(missingPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 120, Short.MAX_VALUE)));
        missingPanelLayout.setVerticalGroup(missingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(missingPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 62, Short.MAX_VALUE)));
        this.outcomeHolder.add((Component)this.missingPanel, "missing");
        this.fileName.setEditable(false);
        this.fileName.setText(NbBundle.getMessage(ProjectContentPanel.class, (String)"ProjectContentPanel.fileName.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectContentPanel.class, (String)"ProjectContentPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.fileName).addComponent(this.outcomeHolder, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outcomeHolder, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

