/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;

public class CombineFilter
extends AbstractFilter {
    private final List<CombineRule> rules;
    private final String name;

    public CombineFilter(String name) {
        this.name = name;
        this.rules = new ArrayList<CombineRule>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void apply(Diagram diagram) {
        Properties.PropertySelector selector = new Properties.PropertySelector(diagram.getFigures());
        for (CombineRule r : this.rules) {
            List list = selector.selectMultiple(r.getFirstMatcher());
            HashSet<Figure> figuresToRemove = new HashSet<Figure>();
            for (Figure f : list) {
                Object s2;
                ArrayList successors = new ArrayList(f.getSuccessors());
                if (r.isReversed()) {
                    if (successors.size() != 1) continue;
                    this.checkCancelled();
                    Figure succ = (Figure)successors.get(0);
                    Object slot = null;
                    block2: for (Object s2 : succ.getInputSlots()) {
                        for (Object c : s2.getConnections()) {
                            if (c.getOutputSlot().getFigure() != f) continue;
                            slot = s2;
                            continue block2;
                        }
                    }
                    assert (slot != null);
                    slot.getSource().addSourceNodes(f.getSource());
                    if (r.getShortProperty() != null) {
                        String s3 = f.getProperties().getString(r.getShortProperty(), null);
                        if (s3 != null && s3.length() > 0) {
                            slot.setShortName(s3);
                            slot.setText(s3);
                            slot.setColor(f.getColor());
                        }
                    } else {
                        assert (slot != null);
                        slot.setText(f.getProperties().getString("dump_spec", null));
                        String n = f.getProperties().getString("shortName", null);
                        if (n != null) {
                            slot.setShortName(n);
                        } else {
                            s2 = f.getProperties().getString("dump_spec", null);
                            if (s2 != null && ((String)s2).length() <= 5) {
                                slot.setShortName((String)s2);
                            }
                        }
                    }
                    for (Object s2 : f.getInputSlots()) {
                        for (Object c : s2.getConnections()) {
                            Connection newConn = diagram.createConnection((InputSlot)slot, c.getOutputSlot(), c.getLabel(), c.getType());
                            newConn.setColor(c.getColor());
                            newConn.setStyle(c.getStyle());
                        }
                    }
                    figuresToRemove.add(f);
                    continue;
                }
                for (Figure succ : successors) {
                    this.checkCancelled();
                    if (succ.getPredecessors().size() != 1 || succ.getInputSlots().size() != 1 || succ.getProperties().selectSingle(r.getSecondMatcher()) == null || succ.getOutputSlots().size() != 1) continue;
                    OutputSlot oldSlot = null;
                    s2 = f.getOutputSlots().iterator();
                    block7: while (s2.hasNext()) {
                        Object c;
                        OutputSlot s4 = (OutputSlot)s2.next();
                        c = s4.getConnections().iterator();
                        while (c.hasNext()) {
                            Connection c2 = (Connection)c.next();
                            if (c2.getInputSlot().getFigure() != succ) continue;
                            oldSlot = s4;
                            continue block7;
                        }
                    }
                    assert (oldSlot != null);
                    OutputSlot nextSlot = (OutputSlot)succ.getOutputSlots().get(0);
                    int pos = 0;
                    String n = succ.getProperties().getString("con", null);
                    if (n != null) {
                        pos = Integer.parseInt(n);
                    }
                    OutputSlot slot = f.createOutputSlot(pos);
                    slot.getSource().addSourceNodes(succ.getSource());
                    if (r.getShortProperty() != null) {
                        s = succ.getProperties().getString(r.getShortProperty(), null);
                        if (s != null && s.length() > 0) {
                            slot.setShortName(s);
                            slot.setText(s);
                            slot.setColor(succ.getColor());
                        }
                    } else {
                        slot.setText(succ.getProperties().getString("dump_spec", null));
                        n = succ.getProperties().getString("shortName", null);
                        if (n != null) {
                            slot.setShortName(n);
                        } else {
                            s = succ.getProperties().getString("dump_spec", null);
                            if (s != null && s.length() <= 2) {
                                slot.setShortName(s);
                            } else {
                                String tmpName = (String)succ.getProperties().get("name", String.class);
                                if (tmpName != null && tmpName.length() > 0) {
                                    slot.setShortName(tmpName.substring(0, 1));
                                }
                            }
                        }
                    }
                    for (Connection c : nextSlot.getConnections()) {
                        Connection newConn = diagram.createConnection(c.getInputSlot(), slot, c.getLabel(), c.getType());
                        newConn.setColor(c.getColor());
                        newConn.setStyle(c.getStyle());
                    }
                    figuresToRemove.add(succ);
                    if (!oldSlot.getConnections().isEmpty()) continue;
                    f.removeSlot((Slot)oldSlot);
                }
            }
            diagram.removeAllFigures(figuresToRemove);
        }
    }

    public void addRule(CombineRule combineRule) {
        this.rules.add(combineRule);
    }

    public static class CombineRule {
        private final Properties.PropertyMatcher first;
        private final Properties.PropertyMatcher second;
        private final boolean reversed;
        private final String shortProperty;

        public CombineRule(Properties.PropertyMatcher first, Properties.PropertyMatcher second) {
            this(first, second, false);
        }

        public CombineRule(Properties.PropertyMatcher first, Properties.PropertyMatcher second, boolean reversed) {
            this(first, second, reversed, null);
        }

        public CombineRule(Properties.PropertyMatcher first, Properties.PropertyMatcher second, boolean reversed, String shortProperty) {
            this.first = first;
            this.second = second;
            this.reversed = reversed;
            this.shortProperty = shortProperty;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public Properties.PropertyMatcher getFirstMatcher() {
            return this.first;
        }

        public Properties.PropertyMatcher getSecondMatcher() {
            return this.second;
        }

        public String getShortProperty() {
            return this.shortProperty;
        }
    }
}

