/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.Bundle;
import org.graalvm.visualizer.filter.FilterEnvironment;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.graph.Diagram;
import org.openide.cookies.OpenCookie;
import org.openide.util.Lookup;

public interface Filter
extends Properties.Provider,
ChangedEventProvider<Filter> {
    public static final Filter NONE = new Filter(){
        private final Properties props = Properties.immutableEmpty();
        private final ChangedEvent<Filter> event = new ChangedEvent<Filter>((Filter)this){

            public void removeListener(ChangedListener<Filter> l) {
            }

            public void addListener(ChangedListener<Filter> l) {
            }
        };

        @Override
        public String getName() {
            return Bundle.FILTER_None();
        }

        @Override
        public void apply(Diagram d) {
        }

        @Override
        public void applyWith(FilterEnvironment env) {
        }

        @Override
        public boolean cancel(FilterEnvironment d) {
            return true;
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public OpenCookie getEditor() {
            return null;
        }

        @Override
        public ChangedEvent<Filter> getChangedEvent() {
            return this.event;
        }

        public Properties getProperties() {
            return this.props;
        }
    };

    public String getName();

    default public void apply(Diagram d) {
        FilterExecution e = FilterExecution.getOrCreate(d, this);
        e.processSingle(this);
    }

    default public void applyWith(FilterEnvironment env) {
        this.apply(env.getDiagram());
    }

    default public boolean cancel(FilterEnvironment d) {
        return false;
    }

    public Lookup getLookup();

    @Deprecated
    public OpenCookie getEditor();

    public ChangedEvent<Filter> getChangedEvent();
}

