/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.script.ScriptEnvironment;

public abstract class FilterEnvironment
implements AutoCloseable {
    private final ScriptEnvironment scriptEnv;
    private final Diagram d;
    private final Map<String, Object> globals = Collections.synchronizedMap(new HashMap());

    protected FilterEnvironment(Diagram d, ScriptEnvironment scriptEnv) {
        this.d = d;
        this.scriptEnv = scriptEnv;
    }

    public ScriptEnvironment getScriptEnvironment() {
        return this.scriptEnv;
    }

    public Diagram getDiagram() {
        return this.d;
    }

    public static FilterEnvironment simple(Diagram d) {
        return FilterChain.createStub(d);
    }

    public Map<String, Object> globals() {
        return this.globals;
    }

    @Override
    public abstract void close() throws IOException;
}

