/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.stream.Stream;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.filter.FilterProvider;
import org.graalvm.visualizer.filter.spi.GraphFilterLocator;
import org.graalvm.visualizer.graph.Diagram;
import org.openide.util.Lookup;

public final class Filters {
    public static void apply(FilterChain chain, Diagram d) {
        FilterExecution.getExecutionService().createExecution(chain, null, d).process();
    }

    public static FilterExecution applyWithCancel(FilterChain chain, Diagram d, FilterChain sequence) {
        return FilterExecution.getExecutionService().createExecution(chain, null, d);
    }

    public static FilterProvider locateChainSource(Lookup lkp) {
        return ((Stream)Lookup.getDefault().lookupAll(GraphFilterLocator.class).stream().sequential()).map(gfl -> gfl.findChain(lkp)).filter(i -> i != null).findFirst().orElse(null);
    }

    public static <T> T lookupFilter(Filter f, Class<T> clazz) {
        if (clazz.isInstance(f)) {
            return clazz.cast(f);
        }
        return (T)f.getLookup().lookup(clazz);
    }

    private Filters() {
    }
}

