/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Selector;
import org.graalvm.visualizer.graph.Slot;

public class RemoveInputsFilter
extends AbstractFilter {
    private List<RemoveInputsRule> rules;
    private String name;

    public RemoveInputsFilter(String name) {
        this.name = name;
        this.rules = new ArrayList<RemoveInputsRule>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void apply(Diagram diagram) {
        for (RemoveInputsRule r : this.rules) {
            this.checkCancelled();
            List list = r.getSelector().selected(diagram);
            for (Figure f : list) {
                int i;
                int z = 0;
                ArrayList<InputSlot> last = new ArrayList<InputSlot>();
                for (InputSlot is : f.getInputSlots()) {
                    if (z >= r.getStartingIndex() && z <= r.getEndIndex() && is.getConnections().size() > 0) {
                        StringBuilder sb = new StringBuilder();
                        List conns = is.getConnections();
                        for (int i2 = 0; i2 < conns.size(); ++i2) {
                            Connection c = (Connection)conns.get(i2);
                            OutputSlot os = c.getOutputSlot();
                            Figure pred = os.getFigure();
                            if (i2 != 0) {
                                sb.append("<BR>");
                            }
                            sb.append(pred.getLines()[0]);
                        }
                        is.removeAllConnections();
                        is.setShortName("X");
                        is.setText(sb.toString());
                        last.add(is);
                    } else {
                        last.clear();
                    }
                    ++z;
                }
                if (last.size() <= 3) continue;
                InputSlot first = (InputSlot)last.get(0);
                first.setShortName("XX");
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < last.size(); ++i) {
                    InputSlot is2 = (InputSlot)last.get(i);
                    if (i != 0) {
                        sb.append("<BR>");
                    }
                    sb.append(is2.getText());
                }
                first.setText(sb.toString());
                for (i = 1; i < last.size(); ++i) {
                    f.removeSlot((Slot)last.get(i));
                }
            }
        }
    }

    public void addRule(RemoveInputsRule rule) {
        this.rules.add(rule);
    }

    public static class RemoveInputsRule {
        private Selector selector;
        private int startingIndex;
        private int endIndex;

        public RemoveInputsRule(Selector selector) {
            this(selector, 0);
        }

        public RemoveInputsRule(Selector selector, int startIndex) {
            this(selector, startIndex, Integer.MAX_VALUE);
        }

        public RemoveInputsRule(Selector selector, int startIndex, int endIndex) {
            this.startingIndex = startIndex;
            this.endIndex = endIndex;
            this.selector = selector;
        }

        public int getStartingIndex() {
            return this.startingIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public Selector getSelector() {
            return this.selector;
        }
    }
}

