/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.ArrayList;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;

public class RemoveSelfLoopsFilter
extends AbstractFilter {
    private String name;

    public RemoveSelfLoopsFilter(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void apply(Diagram d) {
        for (Figure f : d.getFigures()) {
            for (InputSlot is : f.getInputSlots()) {
                this.checkCancelled();
                ArrayList<Connection> toRemove = new ArrayList<Connection>();
                for (Connection c : is.getConnections()) {
                    if (c.getOutputSlot().getFigure() != f) continue;
                    toRemove.add(c);
                }
                for (Connection c : toRemove) {
                    c.remove();
                    OutputSlot os = c.getOutputSlot();
                    if (os.getConnections().isEmpty()) {
                        f.removeSlot((Slot)os);
                    }
                    c.getInputSlot().setShortName("O");
                    c.getInputSlot().setText("Self Loop");
                }
            }
        }
    }
}

