/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;

public class UnconnectedSlotFilter
extends AbstractFilter {
    private final boolean removeInputs;
    private final boolean removeOutputs;

    public UnconnectedSlotFilter(boolean inputs, boolean outputs) {
        this.removeInputs = inputs;
        this.removeOutputs = outputs;
    }

    @Override
    public String getName() {
        return "Unconnected Slot Filter";
    }

    @Override
    public void apply(Diagram d) {
        if (!this.removeInputs && !this.removeOutputs) {
            return;
        }
        Collection figures = d.getFigures();
        for (Figure f : figures) {
            ArrayList<Object> remove = new ArrayList<Object>();
            if (this.removeInputs) {
                for (InputSlot inputSlot : f.getInputSlots()) {
                    if (!inputSlot.getConnections().isEmpty()) continue;
                    remove.add(inputSlot);
                }
            }
            if (this.removeOutputs) {
                for (OutputSlot outputSlot : f.getOutputSlots()) {
                    if (!outputSlot.getConnections().isEmpty()) continue;
                    remove.add(outputSlot);
                }
            }
            for (Slot slot : remove) {
                f.removeSlot(slot);
            }
        }
    }
}

