/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.upgrader.impl;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.graalvm.visualizer.upgrader.Upgrader;
import org.openide.util.NbPreferences;

public class UpgradeFrom_0_26
extends Upgrader {
    private static final String IMPORTING_VERSION = "0.26";
    private static final String LAYOUT_SETTINGS_PATH = "/org/graalvm/visualizer/settings/ui";
    private static final String SETTINGS_PATH = "/org/graalvm/visualizer/settings";

    @Override
    protected void doVersionImport() {
        UpgradeFrom_0_26.doImport();
    }

    public static void doImport() {
        try {
            UpgradeFrom_0_26.transferPreferences(LAYOUT_SETTINGS_PATH);
            UpgradeFrom_0_26.transferPreferences(SETTINGS_PATH);
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    private static void transferPreferences(String path) throws BackingStoreException {
        Preferences oldPrefs = Preferences.userRoot().node(path);
        Preferences newNbPrefs = NbPreferences.root().node(SETTINGS_PATH);
        for (String key : oldPrefs.keys()) {
            newNbPrefs.put(key, oldPrefs.get(key, null));
        }
        newNbPrefs.flush();
    }

    @Override
    protected String getImportingVersion() {
        return IMPORTING_VERSION;
    }

    @Override
    protected String getChangesInfo() {
        return "Migrates LayoutSettings and Setting from java Preferences to NbPreferences.";
    }
}

