/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.event;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.Base64;
import org.netbeans.shaded.json.simple.JSONArray;
import org.netbeans.shaded.json.simple.JSONObject;

@Named(value="ide")
@Singleton
public class NbEventSpy
implements EventSpy {
    @Inject
    private Logger logger;
    @Inject
    private PlexusContainer container;
    private static final AtomicBoolean insideSession = new AtomicBoolean(false);
    private static final AtomicBoolean ignoreInnerSessionEvents = new AtomicBoolean(false);

    public void init(EventSpy.Context context) throws Exception {
    }

    public void onEvent(Object event) throws Exception {
        if (event instanceof ExecutionEvent) {
            Exception exc;
            ExecutionEvent ex = (ExecutionEvent)event;
            if (ignoreInnerSessionEvents.get()) {
                if (ExecutionEvent.Type.SessionEnded.equals((Object)ex.getType())) {
                    ignoreInnerSessionEvents.set(false);
                }
                return;
            }
            JSONObject root = new JSONObject();
            root.put("type", ex.getType().name());
            if (ex.getProject() != null && (ExecutionEvent.Type.ProjectStarted.equals((Object)ex.getType()) || ExecutionEvent.Type.ProjectFailed.equals((Object)ex.getType()) || ExecutionEvent.Type.ProjectSkipped.equals((Object)ex.getType()) || ExecutionEvent.Type.ProjectSucceeded.equals((Object)ex.getType()))) {
                MavenProject mp = ex.getProject();
                JSONObject prj = new JSONObject();
                prj.put("id", mp.getGroupId() + ":" + mp.getArtifactId() + ":" + mp.getVersion());
                if (mp.getFile() != null) {
                    prj.put("file", mp.getFile().getParentFile().getAbsolutePath());
                }
                root.put("prj", prj);
            }
            if (ExecutionEvent.Type.SessionStarted.equals((Object)ex.getType()) || ExecutionEvent.Type.SessionEnded.equals((Object)ex.getType())) {
                root.put("prjcount", ex.getSession().getProjects().size());
                if (ExecutionEvent.Type.SessionStarted.equals((Object)ex.getType())) {
                    if (!insideSession.compareAndSet(false, true)) {
                        ignoreInnerSessionEvents.set(true);
                        return;
                    }
                    if (this.container != null && this.container.getContainerRealm() != null) {
                        ClassRealm cr = this.container.getContainerRealm();
                        JSONArray array = new JSONArray();
                        do {
                            URL[] urls;
                            for (URL url : urls = cr.getURLs()) {
                                array.add(url.toExternalForm());
                            }
                        } while ((cr = cr.getParentRealm()) != null);
                        root.put("mvncoreurls", array);
                    }
                }
                if (ExecutionEvent.Type.SessionEnded.equals((Object)ex.getType())) {
                    insideSession.compareAndSet(true, false);
                }
            }
            if (ex.getMojoExecution() != null && (ExecutionEvent.Type.MojoStarted.equals((Object)ex.getType()) || ExecutionEvent.Type.MojoFailed.equals((Object)ex.getType()) || ExecutionEvent.Type.MojoSkipped.equals((Object)ex.getType()) || ExecutionEvent.Type.MojoSucceeded.equals((Object)ex.getType()))) {
                MavenProject mp;
                MojoDescriptor md;
                InputLocation execLoc;
                PluginExecution exec;
                MojoExecution me = ex.getMojoExecution();
                JSONObject mojo = new JSONObject();
                mojo.put("id", me.getGroupId() + ":" + me.getArtifactId() + ":" + me.getVersion());
                if (me.getGoal() != null) {
                    mojo.put("goal", me.getGoal());
                }
                if (me.getSource() != null) {
                    mojo.put("source", me.getSource().name());
                }
                if (me.getExecutionId() != null) {
                    mojo.put("execId", me.getExecutionId());
                }
                if (me.getLifecyclePhase() != null) {
                    mojo.put("phase", me.getLifecyclePhase());
                }
                if ((exec = (PluginExecution)me.getPlugin().getExecutionsAsMap().get(me.getExecutionId())) != null && (execLoc = exec.getLocation((Object)"")) != null) {
                    String mid;
                    JSONObject loc = new JSONObject();
                    loc.put("ln", execLoc.getLineNumber());
                    loc.put("col", execLoc.getColumnNumber());
                    String locS = execLoc.getSource().getLocation();
                    if (locS != null) {
                        loc.put("loc", locS);
                    }
                    if ((mid = execLoc.getSource().getModelId()) != null) {
                        loc.put("id", mid);
                    }
                    mojo.put("loc", loc);
                }
                if ((md = me.getMojoDescriptor()) != null) {
                    ClassRealm cr;
                    mojo.put("impl", md.getImplementation());
                    PluginDescriptor pd = md.getPluginDescriptor();
                    if (pd != null && (cr = pd.getClassRealm()) != null) {
                        URL[] urls = cr.getURLs();
                        JSONArray array = new JSONArray();
                        for (URL url : urls) {
                            array.add(url.toExternalForm());
                        }
                        mojo.put("urls", array);
                    }
                }
                if ((mp = ex.getProject()) != null && mp.getFile() != null) {
                    mojo.put("prjFile", mp.getFile().getParentFile().getAbsolutePath());
                }
                root.put("mojo", mojo);
            }
            if (ExecutionEvent.Type.MojoFailed.equals((Object)ex.getType()) && ex.getException() != null && (exc = ex.getException()) instanceof LifecycleExecutionException) {
                JSONObject excep = new JSONObject();
                String message = exc.getCause().getMessage();
                byte[] enc = Base64.encodeBase64((byte[])message.getBytes(StandardCharsets.UTF_8));
                String encString = new String(enc, StandardCharsets.UTF_8);
                excep.put("msg", encString);
                root.put("exc", excep);
            }
            this.logger.info("NETBEANS-ExecEvent:" + root.toString());
        }
    }

    public void close() throws Exception {
    }
}

