/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.connection;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import jdk.graal.compiler.graphio.parsing.DocumentFactory;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import org.graalvm.visualizer.connection.Bundle;
import org.graalvm.visualizer.connection.Client;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class Server
implements PreferenceChangeListener {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    private static final int MAX_PARALLEL_READS = 50;
    private ServerSocketChannel serverSocket;
    private final DocumentFactory rootDocumentFactory;
    private final ParseMonitor monitor;
    private int port;
    private boolean network;
    private Runnable serverRunnable;
    private int clientCount;
    private static final RequestProcessor NETWORK_RP = new RequestProcessor(Server.class.getName(), 50);
    private final RequestProcessor streamLoader = new RequestProcessor(Client.class.getName(), 10);
    private RequestProcessor.Task refreshTask;

    public Server(DocumentFactory rootDocumentFactory, ParseMonitor monitor) {
        this.rootDocumentFactory = rootDocumentFactory;
        this.monitor = monitor;
        this.initializeNetwork();
        GraalSettings s = GraalSettings.obtain();
        s.addPreferenceChangeListener((PreferenceChangeListener)this);
        if (((Boolean)s.get(Boolean.class, "cleanCaches")).booleanValue()) {
            this.cleanCacheDir();
        }
    }

    private void cleanCacheDir() {
        File f = Places.getCacheSubdirectory((String)"igv");
        if (!f.exists() || !f.isDirectory()) {
            return;
        }
        Path rootPath = f.toPath();
        try {
            Files.list(rootPath).sorted(Comparator.reverseOrder()).map(Path::toFile).peek(n -> LOG.log(Level.FINE, "Deleting {0}", n)).forEach(File::delete);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not delete caches", Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preferenceChange(PreferenceChangeEvent e) {
        GraalSettings set = GraalSettings.obtain();
        int curPort = (Integer)set.get(Integer.class, "portBinary");
        boolean net = (Boolean)set.get(Boolean.class, "acceptNetwork");
        Server server = this;
        synchronized (server) {
            if (curPort == this.port && net == this.network) {
                return;
            }
        }
        this.refreshNetwork();
    }

    private synchronized void refreshNetwork() {
        if (this.refreshTask == null) {
            this.refreshTask = NETWORK_RP.post(this::initializeNetwork, 200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNetwork() {
        Runnable runnable;
        ServerSocketChannel ss;
        Server server = this;
        synchronized (server) {
            this.refreshTask = null;
        }
        GraalSettings set = GraalSettings.obtain();
        int curPort = (Integer)set.get(Integer.class, "portBinary");
        boolean net = (Boolean)set.get(Boolean.class, "acceptNetwork");
        Server server2 = this;
        synchronized (server2) {
            ss = this.serverSocket;
            this.port = curPort;
            this.network = (Boolean)set.get(Boolean.class, "acceptNetwork");
        }
        try {
            if (ss != null) {
                ss.close();
                this.serverSocket = null;
            }
            InetAddress bindTo = net ? null : InetAddress.getLoopbackAddress();
            Server server3 = this;
            synchronized (server3) {
                this.serverSocket = ServerSocketChannel.open();
                this.serverSocket.bind(new InetSocketAddress(bindTo, curPort));
            }
        }
        catch (IOException ex) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.ERR_CannotListen(), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            return;
        }
        this.serverRunnable = runnable = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [35[UNCONDITIONALDOLOOP]], but top level block is 17[MONITOR]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        RequestProcessor.getDefault().post(runnable, 0, 10);
    }

    protected DocumentFactory onNewClient() {
        return null;
    }

    protected void onAllClientsClosed() {
    }

    private synchronized void notifyClientTerminated() {
        if (--this.clientCount == 0) {
            this.onAllClientsClosed();
        }
    }
}

